/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.util;

import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;

public class PeriodHelper {
    private PeriodHelper() {
    }

    public static Period getPeriod(IMObjectBean bean, String name) {
        return PeriodHelper.getPeriod(bean, name, name + "Units");
    }

    public static Period getPeriod(IMObjectBean bean, String periodName, String unitsName) {
        return PeriodHelper.getPeriod(bean, periodName, unitsName, (DateUnits)null);
    }

    public static Period getPeriod(IMObjectBean bean, String periodName, String unitsName, DateUnits defaultUnits) {
        DateUnits units;
        Period result = null;
        int period = bean.getInt(periodName, -1);
        if (period > 0 && (units = DateUnits.fromString(bean.getString(unitsName), defaultUnits)) != null) {
            result = units.toPeriod(period);
        }
        return result;
    }

    public static Period getPeriod(IMObjectBean bean, String periodName, String unitsName, Period defaultPeriod) {
        Period period = PeriodHelper.getPeriod(bean, periodName, unitsName, (DateUnits)null);
        return period != null ? period : defaultPeriod;
    }
}

