/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.archetype.rules.user.UserQueryFactory;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.util.StringUtilities;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class UserRules {
    private final IArchetypeService service;
    private static final String LOCATIONS = "locations";

    public UserRules(IArchetypeService service) {
        this.service = service;
    }

    public User getUser(String username) {
        ArchetypeQuery query = new ArchetypeQuery("security.user", true, true);
        query.add((IConstraint)new NodeConstraint("username", (Object)username));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        if (iterator.hasNext()) {
            return (User)iterator.next();
        }
        return null;
    }

    public User getUser(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        User user = null;
        if (principal instanceof User) {
            user = (User)principal;
        } else if (principal instanceof UserDetails) {
            String name = ((UserDetails)principal).getUsername();
            user = this.getUser(name);
        }
        return user;
    }

    public boolean exists(String username) {
        return this.checkExists(username, null);
    }

    public boolean exists(String username, User user) {
        return this.checkExists(username, user);
    }

    public boolean isClinician(User user) {
        return this.isA(user, "CLINICIAN");
    }

    public boolean isAdministrator(User user) {
        boolean result = this.isA(user, "ADMINISTRATOR");
        if (!result) {
            result = user.isA("security.user") && "admin".equals(user.getUsername());
        }
        return result;
    }

    public boolean isA(User user, String userType) {
        if (user.isA("security.user")) {
            for (Lookup lookup : user.getClassifications()) {
                if (!lookup.isA("lookup.userType") || !userType.equals(lookup.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    public List<Party> getLocations(User user) {
        IMObjectBean bean = this.service.getBean((IMObject)user);
        return bean.getTargets(LOCATIONS, Party.class, Policies.active());
    }

    public List<Party> getLocations(User user, Party practice) {
        List locations = this.getLocations(user);
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        if (locations.isEmpty()) {
            locations = bean.getTargets(LOCATIONS, Party.class, Policies.active());
        } else {
            List references = bean.getTargetRefs(LOCATIONS);
            locations.removeIf(location -> !references.contains(location.getObjectReference()));
        }
        return locations;
    }

    public Party getDefaultLocation(User user) {
        return (Party)EntityRelationshipHelper.getDefaultTarget((Entity)user, LOCATIONS, (ArchetypeService)this.service);
    }

    public List<Entity> getDepartments(User user) {
        IMObjectBean bean = this.service.getBean((IMObject)user);
        List departments = bean.getTargets("departments", Entity.class, Policies.active());
        if (departments.isEmpty()) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Entity.class);
            Root root = query.from(Entity.class, new String[]{"entity.department"});
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
            departments = this.service.createQuery(query).getResultList();
        }
        return departments;
    }

    public Entity getDefaultDepartment(User user, List<Entity> departments) {
        EntityLink link;
        Entity result = null;
        Iterator iterator = this.service.getBean((IMObject)user).getValues("departments", EntityLink.class).iterator();
        while (iterator.hasNext() && (!this.service.getBean((IMObject)(link = (EntityLink)iterator.next())).getBoolean("default") || (result = (Entity)departments.stream().filter(department -> Objects.equals(department.getObjectReference(), link.getTarget())).findFirst().orElse(null)) == null)) {
        }
        return result;
    }

    public DocumentAct getSignature(User user) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DocumentAct.class);
        Root root = query.from(DocumentAct.class, new String[]{"act.documentSignature"});
        Join userJoin = root.join("user").join("entity");
        userJoin.on((Expression)builder.equal((Expression)userJoin.get("id"), (Object)user.getId()));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return (DocumentAct)this.service.createQuery(query).getFirstResult();
    }

    public Set<User> getUsers(List<Entity> usersOrGroups) {
        HashSet<User> result = new HashSet<User>();
        HashSet<Entity> groups = new HashSet<Entity>();
        for (Entity entity : usersOrGroups) {
            if (entity instanceof User) {
                result.add((User)entity);
                continue;
            }
            if (entity == null || groups.contains(entity)) continue;
            groups.add(entity);
            List<User> users = this.getUsers(entity);
            result.addAll(users);
        }
        return result;
    }

    public List<User> getUsers(Entity group) {
        IMObjectBean bean = this.service.getBean((IMObject)group);
        return bean.getTargets("users", User.class);
    }

    public List<Entity> getFollowupWorkLists(User user) {
        return this.service.getBean((IMObject)user).getTargets("followupWorkLists", Entity.class, Policies.orderBySequence());
    }

    public List<User> getClinicians(Party location) {
        ArchetypeQuery query = UserQueryFactory.createClinicianQuery(location, "id");
        query.setMaxResults(-1);
        List results = this.service.get((IArchetypeQuery)query).getResults();
        return results;
    }

    public boolean canEdit(User user, String archetype) {
        boolean create = false;
        boolean save = false;
        Collection authorities = ((org.openvpms.component.business.domain.im.security.User)user).getAuthorities();
        for (GrantedAuthority grant : authorities) {
            ArchetypeAwareGrantedAuthority authority;
            if (!(grant instanceof ArchetypeAwareGrantedAuthority) || !"archetypeService".equals((authority = (ArchetypeAwareGrantedAuthority)grant).getServiceName())) continue;
            String method = authority.getMethod();
            if (!StringUtilities.matches((String)archetype, (String)authority.getShortName())) continue;
            if (!create && StringUtilities.matches((String)"create", (String)method)) {
                create = true;
            }
            if (!save && StringUtilities.matches((String)"save", (String)method)) {
                save = true;
            }
            if (!create || !save) continue;
            break;
        }
        return create && save;
    }

    public boolean canSave(User user, String archetype) {
        return this.checkPermission(user, archetype, "save");
    }

    public boolean canRemove(User user, String archetype) {
        return this.checkPermission(user, archetype, "remove");
    }

    public Entity getJobUsedBy(User user) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root job = query.from(Entity.class, new String[]{"entity.job*"});
        query.select((Selection)job);
        Root relationship = query.from(EntityLink.class, new String[]{"entityLink.jobUser", "entityLink.jobUserGroup"});
        query.where(new Predicate[]{builder.equal((Expression)job.get("id"), (Expression)relationship.get("source")), builder.equal((Expression)relationship.get("target"), (Object)user.getId()), builder.equal((Expression)job.get("active"), (Object)true)});
        query.orderBy(new Order[]{builder.asc((Expression)job.get("id"))});
        return (Entity)this.service.createQuery(query).getFirstResult();
    }

    public boolean roleExists(String name, long id) {
        return this.checkExists(name, id, SecurityRole.class, "security.role");
    }

    public boolean authorityExists(String name, long id) {
        return this.checkExists(name, id, ArchetypeAwareGrantedAuthority.class, "security.archetypeAuthority");
    }

    private boolean checkPermission(User user, String archetype, String action) {
        Collection authorities = ((org.openvpms.component.business.domain.im.security.User)user).getAuthorities();
        for (GrantedAuthority grant : authorities) {
            ArchetypeAwareGrantedAuthority authority;
            if (!(grant instanceof ArchetypeAwareGrantedAuthority) || !"archetypeService".equals((authority = (ArchetypeAwareGrantedAuthority)grant).getServiceName())) continue;
            String method = authority.getMethod();
            if (!StringUtilities.matches((String)archetype, (String)authority.getShortName()) || !StringUtilities.matches((String)action, (String)method)) continue;
            return true;
        }
        return false;
    }

    private <T extends IMObject> boolean checkExists(String name, long id, Class<T> type, String archetype) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root from = query.from(type, new String[]{archetype});
        query.select((Selection)from.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)from.get("name"), (Object)name));
        if (id != -1L) {
            predicates.add(builder.notEqual((Expression)from.get("id"), (Object)id));
        }
        query.where(predicates);
        return this.service.createQuery(query).getFirstResult() != null;
    }

    private boolean checkExists(String username, User user) {
        ArchetypeQuery query = new ArchetypeQuery("security.user", true, false);
        query.add((IConstraint)new NodeSelectConstraint("id"));
        query.add((IConstraint)new NodeConstraint("username", (Object)username));
        if (user != null && !user.isNew()) {
            query.add((IConstraint)Constraints.ne((String)"id", (Object)user.getId()));
        }
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext();
    }
}

