/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.user;

import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeIdConstraint;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;

public class UserQueryFactory {
    private UserQueryFactory() {
    }

    public static ArchetypeQuery createUserQuery(Party location, String ... sort) {
        ArchetypeQuery query = new ArchetypeQuery("security.user", true, true);
        UserQueryFactory.addLocationConstraint(location, query);
        if (sort.length != 0) {
            UserQueryFactory.addSort(query, sort);
        }
        return query;
    }

    public static ArchetypeQuery createClinicianQuery(Party location, String ... sort) {
        ArchetypeQuery query = new ArchetypeQuery("security.user", true, true);
        UserQueryFactory.addClinicianConstraint(query);
        UserQueryFactory.addLocationConstraint(location, query);
        if (sort.length != 0) {
            UserQueryFactory.addSort(query, sort);
        }
        return query;
    }

    public static ArchetypeQuery addClinicianConstraint(ArchetypeQuery query) {
        query.add((IConstraint)Constraints.join((String)"classifications", (BaseArchetypeConstraint)new ArchetypeIdConstraint("lookup.userType")).add((IConstraint)Constraints.eq((String)"code", (Object)"CLINICIAN")));
        return query;
    }

    public static ArchetypeQuery addLocationConstraint(Party location, ArchetypeQuery query) {
        if (location != null) {
            BaseArchetypeConstraint archetype = query.getArchetypeConstraint();
            String alias = archetype.getAlias();
            if (alias == null) {
                alias = "u";
                archetype.setAlias(alias);
            }
            query.add((IConstraint)Constraints.leftJoin((String)"locations", (String)"l"));
            query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.eq((String)"l.target", (Object)location), Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String)"security.user", (String)"u2").add((IConstraint)Constraints.join((String)"locations", (String)"l2").add((IConstraint)Constraints.idEq((String)alias, (String)"u2"))))}));
        }
        return query;
    }

    private static void addSort(ArchetypeQuery query, String[] sort) {
        for (String node : sort) {
            query.add((IConstraint)Constraints.sort((String)node));
        }
    }
}

