/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.ProductOrder;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class SupplierRules {
    private final IArchetypeService service;
    private static final List<String> PRODUCT_ON_ORDER = Arrays.asList("orderId", "date", "supplierId", "supplierArchetype", "supplierName", "quantity", "packageSize", "packageUnits");

    public SupplierRules(IArchetypeService service) {
        this.service = service;
    }

    public Party getReferralVetPractice(Party vet, Date time) {
        return this.getReferralVetPractice(vet, time, true);
    }

    public Party getReferralVetPractice(Party vet, Date time, boolean active) {
        IMObjectBean bean = this.service.getBean((IMObject)vet);
        return (Party)bean.getSource("practices", Policies.active((Date)time, (boolean)active));
    }

    public boolean isSuppliedBy(Party supplier, Product product) {
        Predicate predicate;
        IMObjectBean bean = this.service.getBean((IMObject)product);
        return bean.getValue("suppliers", Relationship.class, predicate = Predicates.activeNow().and(Predicates.targetEquals((IMObject)supplier))) != null;
    }

    public List<ProductSupplier> getProductSuppliers(Party supplier) {
        ArrayList<ProductSupplier> result = new ArrayList<ProductSupplier>();
        ArchetypeQuery query = new ArchetypeQuery("entityLink.productSupplier");
        query.add((IConstraint)Constraints.eq((String)"target", (Object)supplier));
        Date now = new Date();
        query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.lte((String)"activeStartTime", (Object)now)}));
        query.add((IConstraint)Constraints.lte((String)"activeStartTime", (Object)now));
        query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.gte((String)"activeEndTime", (Object)now), Constraints.isNull((String)"activeEndTime")}));
        query.setMaxResults(-1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            result.add(new ProductSupplier((Relationship)iterator.next(), this.service));
        }
        return result;
    }

    public EntityRelationship getSupplierStockLocation(Act order) {
        IMObjectBean bean = this.service.getBean((IMObject)order);
        Party supplier = (Party)bean.getTarget("supplier", Party.class);
        Party stockLocation = (Party)bean.getTarget("stockLocation", Party.class);
        return supplier != null && stockLocation != null ? this.getSupplierStockLocation(supplier, stockLocation) : null;
    }

    public EntityRelationship getSupplierStockLocation(Party supplier, Party stockLocation) {
        IMObjectBean bean = this.service.getBean((IMObject)supplier);
        List relationships = bean.getValues("stockLocations", EntityRelationship.class, Predicates.activeNow().and(Predicates.targetEquals((IMObject)stockLocation)));
        return !relationships.isEmpty() ? (EntityRelationship)relationships.get(0) : null;
    }

    public String getAccountId(long supplierId, Party location) {
        String accountId = null;
        ArchetypeQuery query = new ArchetypeQuery("party.supplier*", false);
        query.add((IConstraint)Constraints.eq((String)"id", (Object)supplierId));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        if (iterator.hasNext()) {
            Party supplier = (Party)iterator.next();
            accountId = this.getAccountId(supplier, location);
        }
        return accountId;
    }

    public String getAccountId(Party supplier, Party location) {
        String accountId = null;
        EntityLink relationship = this.getSupplierLocation(supplier, location);
        if (relationship != null) {
            IMObjectBean bean = this.service.getBean((IMObject)relationship);
            accountId = bean.getString("accountId");
        }
        return accountId;
    }

    public EntityLink getSupplierLocation(Party supplier, Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)supplier);
        return (EntityLink)bean.getValue("locations", EntityLink.class, Predicates.activeNow().and(Predicates.targetEquals((IMObject)location)));
    }

    public List<ProductOrder> getOrders(Product product, Party stockLocation) {
        return this.getOrders(product.getObjectReference(), stockLocation.getObjectReference());
    }

    public List<ProductOrder> getOrders(Reference product, Reference stockLocation) {
        ArrayList<ProductOrder> result = new ArrayList<ProductOrder>();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("productId", product.getId());
        parameters.put("stockLocationId", stockLocation.getId());
        NamedQuery query = new NamedQuery("getProductOnOrder", PRODUCT_ON_ORDER, parameters);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            long orderId = set.getLong("orderId");
            long supplierId = set.getLong("supplierId");
            String supplierArchetype = set.getString("supplierArchetype");
            String supplierName = set.getString("supplierName");
            Date date = set.getDate("date");
            BigDecimal quantity = set.getBigDecimal("quantity");
            Integer packageSize = (Integer)set.get("packageSize");
            String packageUnits = set.getString("packageUnits");
            result.add(new ProductOrder((Reference)new IMObjectReference("act.supplierOrder", orderId), date, (Reference)new IMObjectReference(supplierArchetype, supplierId), supplierName, quantity, packageSize, packageUnits));
        }
        return result;
    }
}

