/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

class Stock {
    private final Product product;
    private final Party stockLocation;
    private final Party supplier;
    private final long productSupplierId;
    private final BigDecimal quantity;
    private final BigDecimal idealQty;
    private final BigDecimal onOrder;
    private final BigDecimal toOrder;
    private final String reorderCode;
    private final String reorderDescription;
    private final int packageSize;
    private final String packageUnits;
    private final BigDecimal unitPrice;
    private final BigDecimal listPrice;

    public Stock(Product product, Party stockLocation, Party supplier, long productSupplierId, BigDecimal quantity, BigDecimal idealQty, BigDecimal onOrder, BigDecimal toOrder, String reorderCode, String reorderDescription, int packageSize, String packageUnits, BigDecimal unitPrice, BigDecimal listPrice) {
        this.product = product;
        this.stockLocation = stockLocation;
        this.supplier = supplier;
        this.productSupplierId = productSupplierId;
        this.quantity = quantity;
        this.idealQty = idealQty;
        this.onOrder = onOrder;
        this.toOrder = toOrder;
        this.reorderCode = reorderCode;
        this.reorderDescription = reorderDescription;
        this.packageSize = packageSize;
        this.packageUnits = packageUnits;
        this.unitPrice = unitPrice;
        this.listPrice = listPrice;
    }

    public Product getProduct() {
        return this.product;
    }

    public Party getStockLocation() {
        return this.stockLocation;
    }

    public Party getSupplier() {
        return this.supplier;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public BigDecimal getIdealQty() {
        return this.idealQty;
    }

    public BigDecimal getOnOrder() {
        return this.onOrder;
    }

    public BigDecimal getToOrder() {
        return this.toOrder;
    }

    public String getReorderCode() {
        return this.reorderCode;
    }

    public String getReorderDescription() {
        return this.reorderDescription;
    }

    public int getPackageSize() {
        return this.packageSize;
    }

    public String getPackageUnits() {
        return this.packageUnits;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public BigDecimal getListPrice() {
        return this.listPrice;
    }

    public String toString() {
        return "Stock[productSupplierId=" + this.productSupplierId + ", product=" + this.product.getName() + " (" + this.product.getId() + "), location=" + this.stockLocation.getName() + " (" + this.stockLocation.getId() + "), supplier=" + this.supplier.getName() + " (" + this.supplier.getId() + "), onHand=" + this.quantity + ", onOrder=" + this.onOrder + ", toOrder=" + this.toOrder + ", idealQty=" + this.idealQty + ", reorderCode=" + this.reorderCode + ", reorderDescription=" + this.reorderDescription + ", packageSize=" + this.packageSize + ", packageUnits=" + this.packageUnits + "]";
    }

    long getProductSupplierId() {
        return this.productSupplierId;
    }
}

