/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.act.ActCopyHandler;
import org.openvpms.archetype.rules.act.DefaultActCopyHandler;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.supplier.DeliveryProcessor;
import org.openvpms.archetype.rules.supplier.DeliveryStatus;
import org.openvpms.archetype.rules.supplier.OrderGenerator;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class OrderRules {
    private final TaxRules taxRules;
    private final IArchetypeService service;
    private final ProductRules productRules;
    private static final String RECEIVED_QUANTITY = "receivedQuantity";
    private static final String CANCELLED_QUANTITY = "cancelledQuantity";

    public OrderRules(TaxRules taxRules, IArchetypeService service, ProductRules productRules) {
        this.taxRules = taxRules;
        this.service = service;
        this.productRules = productRules;
    }

    public DeliveryStatus getDeliveryStatus(FinancialAct orderItem) {
        return DeliveryProcessor.getDeliveryStatus(orderItem, (ArchetypeService)this.service);
    }

    public FinancialAct copyOrder(FinancialAct order, String title) {
        List<IMObject> objects = this.copy((Act)order, "act.supplierOrder", (IMObjectCopyHandler)new DefaultActCopyHandler(), new Date(), false);
        FinancialAct copy = (FinancialAct)objects.get(0);
        copy.setStatus2(DeliveryStatus.PENDING.toString());
        copy.setTitle(title);
        for (IMObject object : objects) {
            if (!TypeHelper.isA((IMObject)object, (String)"act.supplierOrderItem")) continue;
            IMObjectBean itemBean = this.service.getBean(object);
            itemBean.setValue(RECEIVED_QUANTITY, (Object)BigDecimal.ZERO);
            itemBean.setValue(CANCELLED_QUANTITY, (Object)BigDecimal.ZERO);
        }
        this.service.save(objects);
        return copy;
    }

    public FinancialAct createDeliveryItem(FinancialAct orderItem) {
        BigDecimal cancelled;
        BigDecimal received;
        List<IMObject> objects = this.copy((Act)orderItem, "act.supplierOrderItem", (IMObjectCopyHandler)new DeliveryItemHandler(), orderItem.getActivityStartTime(), false);
        IMObjectBean order = this.service.getBean((IMObject)orderItem);
        BigDecimal quantity = orderItem.getQuantity();
        BigDecimal remaining = quantity.subtract((received = order.getBigDecimal(RECEIVED_QUANTITY)).add(cancelled = order.getBigDecimal(CANCELLED_QUANTITY)));
        if (remaining.compareTo(BigDecimal.ZERO) < 0) {
            remaining = BigDecimal.ZERO;
        }
        FinancialAct delivery = (FinancialAct)objects.get(0);
        delivery.setQuantity(remaining);
        return delivery;
    }

    public FinancialAct createReturnItem(FinancialAct orderItem) {
        List<IMObject> objects = this.copy((Act)orderItem, "act.supplierOrderItem", (IMObjectCopyHandler)new ReturnItemHandler(), orderItem.getActivityStartTime(), false);
        IMObjectBean order = this.service.getBean((IMObject)orderItem);
        BigDecimal received = order.getBigDecimal(RECEIVED_QUANTITY);
        FinancialAct item = (FinancialAct)objects.get(0);
        item.setQuantity(received);
        return (FinancialAct)objects.get(0);
    }

    public FinancialAct invoiceSupplier(Act delivery) {
        if (this.isInvoiced(delivery)) {
            throw new IllegalStateException("The delivery has already been invoiced");
        }
        IMObjectBean bean = this.service.getBean((IMObject)delivery);
        List<IMObject> objects = this.copy(delivery, "act.supplierDelivery", (IMObjectCopyHandler)new DeliveryHandler(), new Date(), false);
        FinancialAct invoice = (FinancialAct)objects.get(0);
        Relationship relationship = bean.addTarget("invoice", (IMObject)invoice);
        invoice.addActRelationship((ActRelationship)relationship);
        objects.add((IMObject)delivery);
        this.service.save(objects);
        return invoice;
    }

    public boolean isInvoiced(Act delivery) {
        IMObjectBean bean = this.service.getBean((IMObject)delivery);
        return !bean.getTargetRefs("invoice").isEmpty();
    }

    public FinancialAct creditSupplier(Act supplierReturn) {
        if (this.isCredited(supplierReturn)) {
            throw new IllegalStateException("The return is already linked to a credit");
        }
        IMObjectBean bean = this.service.getBean((IMObject)supplierReturn);
        List<IMObject> objects = this.copy(supplierReturn, "act.supplierReturn", (IMObjectCopyHandler)new ReturnHandler(), new Date(), false);
        FinancialAct credit = (FinancialAct)objects.get(0);
        ActRelationship relationship = (ActRelationship)bean.addTarget("returnCredit", (IMObject)credit);
        credit.addActRelationship(relationship);
        objects.add((IMObject)supplierReturn);
        this.service.save(objects);
        return (FinancialAct)objects.get(0);
    }

    public boolean isCredited(Act supplierReturn) {
        IMObjectBean bean = this.service.getBean((IMObject)supplierReturn);
        return !bean.getTargetRefs("returnCredit").isEmpty();
    }

    public FinancialAct reverseDelivery(Act supplierDelivery) {
        List<IMObject> objects = this.copy(supplierDelivery, "act.supplierDelivery", (IMObjectCopyHandler)new ReverseHandler(true), new Date(), true);
        return (FinancialAct)objects.get(0);
    }

    public FinancialAct reverseReturn(FinancialAct supplierReturn) {
        List<IMObject> objects = this.copy((Act)supplierReturn, "act.supplierReturn", (IMObjectCopyHandler)new ReverseHandler(false), new Date(), true);
        return (FinancialAct)objects.get(0);
    }

    public List<FinancialAct> createOrder(Party supplier, Party stockLocation, boolean belowIdealQuantity) {
        OrderGenerator generator = new OrderGenerator(this.taxRules, this.service);
        return generator.createOrder(supplier, stockLocation, belowIdealQuantity);
    }

    public boolean hasRestrictedProducts(Act order) {
        boolean result = false;
        List items = this.service.getBean((IMObject)order).getTargets("items", Act.class);
        for (Act item : items) {
            IMObjectBean bean = this.service.getBean((IMObject)item);
            Product product = (Product)bean.getTarget("product", Product.class);
            if (product == null || !this.productRules.isRestricted(product)) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<IMObject> copy(Act object, String type, IMObjectCopyHandler handler, Date startTime, boolean save) {
        if (!TypeHelper.isA((IMObject)object, (String)type)) {
            throw new IllegalArgumentException("Expected a " + type + " for argument 'object', but got a" + object.getArchetype());
        }
        IMObjectCopier copier = new IMObjectCopier(handler, (ArchetypeService)this.service);
        List objects = copier.apply((IMObject)object);
        Act act = (Act)objects.get(0);
        act.setActivityStartTime(startTime);
        if (save) {
            this.service.save((Collection)objects);
        }
        return objects;
    }

    private static class ReverseHandler
    extends SupplierActCopyHandler {
        private static final String[][] TYPE_MAP = new String[][]{{"act.supplierDelivery", "act.supplierReturn"}, {"act.supplierDeliveryItem", "act.supplierReturnItem"}, {"actRelationship.supplierDeliveryItem", "actRelationship.supplierReturnItem"}, {"actRelationship.supplierDeliveryOrderItem", "actRelationship.supplierReturnOrderItem"}};

        public ReverseHandler(boolean delivery) {
            super(TYPE_MAP);
            this.setReference("act.supplierOrderItem");
            this.setReverse(!delivery);
            this.setExclude("actRelationship.supplierDeliveryInvoice");
        }
    }

    private static class ReturnHandler
    extends SupplierActCopyHandler {
        private static final String[][] TYPE_MAP = new String[][]{{"act.supplierReturn", "act.supplierAccountChargesCredit"}, {"act.supplierReturnItem", "act.supplierAccountCreditItem"}, {"actRelationship.supplierReturnItem", "actRelationship.supplierAccountCreditItem"}, {"participation.stockLocation", null}};

        public ReturnHandler() {
            super(TYPE_MAP);
            this.setExclude("actRelationship.supplierReturnCredit");
        }
    }

    private static class DeliveryHandler
    extends SupplierActCopyHandler {
        private static final String[][] TYPE_MAP = new String[][]{{"act.supplierDelivery", "act.supplierAccountChargesInvoice"}, {"act.supplierDeliveryItem", "act.supplierAccountInvoiceItem"}, {"actRelationship.supplierDeliveryItem", "actRelationship.supplierAccountInvoiceItem"}, {"actRelationship.supplierDeliveryOrderItem", null}, {"participation.stockLocation", null}};

        public DeliveryHandler() {
            super(TYPE_MAP);
        }
    }

    private static class ReturnItemHandler
    extends SupplierActCopyHandler {
        private static final String[][] TYPE_MAP = new String[][]{{"act.supplierOrderItem", "act.supplierReturnItem"}};

        public ReturnItemHandler() {
            super(TYPE_MAP);
            this.setCopy(Act.class, Participation.class);
            this.setExclude(ActRelationship.class);
        }
    }

    private static class DeliveryItemHandler
    extends SupplierActCopyHandler {
        private static final String[][] TYPE_MAP = new String[][]{{"act.supplierOrderItem", "act.supplierDeliveryItem"}};

        public DeliveryItemHandler() {
            super(TYPE_MAP);
            this.setCopy(Act.class, Participation.class);
            this.setExclude(ActRelationship.class);
        }
    }

    private static abstract class SupplierActCopyHandler
    extends ActCopyHandler {
        protected SupplierActCopyHandler(String[][] shortNameMap) {
            super(shortNameMap);
        }

        @Override
        protected boolean isCopyable(ArchetypeDescriptor archetype, NodeDescriptor node, boolean source) {
            if ("credit".equals(node.getName())) {
                return false;
            }
            return super.isCopyable(archetype, node, source);
        }
    }
}

