/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock.io;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.stock.io.StockCSVReader;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.archetype.rules.stock.io.StockDataFilter;
import org.openvpms.archetype.rules.stock.io.StockDataSet;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;

public class StockDataImporter {
    private final IArchetypeService service;
    private final char separator;
    private final DocumentHandlers handlers;
    private final StockDataFilter filter;

    public StockDataImporter(IArchetypeService service, DocumentHandlers handlers, char separator) {
        this.service = service;
        this.handlers = handlers;
        this.separator = separator;
        this.filter = new StockDataFilter(service);
    }

    public StockDataSet load(Document document, String reason) {
        StockCSVReader reader = new StockCSVReader(this.handlers, this.separator);
        StockDataSet data = reader.read(document);
        if (data.getErrors().isEmpty() && !data.getData().isEmpty() && (data = this.filter.filter(data.getData())).getErrors().isEmpty() && !data.getData().isEmpty()) {
            data = this.load(data.getData(), reason);
        }
        return data;
    }

    private StockDataSet load(List<StockData> data, String reason) {
        Act act = (Act)this.service.create("act.stockAdjust", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget("stockLocation", data.get(0).getStockLocation());
        bean.setValue("reason", (Object)reason);
        ArrayList<Act> toSave = new ArrayList<Act>();
        toSave.add(act);
        for (StockData item : data) {
            Act child = (Act)this.service.create("act.stockAdjustItem", Act.class);
            BigDecimal quantity = item.getNewQuantity().subtract(item.getQuantity());
            IMObjectBean childBean = this.service.getBean((IMObject)child);
            childBean.setTarget("product", item.getProduct());
            childBean.setValue("quantity", (Object)quantity);
            bean.addTarget("items", (IMObject)child, "stockAdjust");
            toSave.add(child);
        }
        this.service.save(toSave);
        return new StockDataSet(data, act);
    }
}

