/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductDataComparator;
import org.openvpms.archetype.rules.product.io.ProductDataSet;
import org.openvpms.archetype.rules.product.io.ProductIOException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class ProductDataFilter {
    private final IArchetypeService service;
    private final ProductDataComparator comparer;

    public ProductDataFilter(ProductPriceRules rules, IArchetypeService service) {
        this.comparer = new ProductDataComparator(rules, (ArchetypeService)service);
        this.service = service;
    }

    public ProductDataSet filter(List<ProductData> input) {
        ArrayList<ProductData> output = new ArrayList<ProductData>();
        ArrayList<ProductData> errors = new ArrayList<ProductData>();
        for (ProductData data : input) {
            ArchetypeQuery query = new ArchetypeQuery("product.*");
            query.add((IConstraint)Constraints.eq((String)"id", (Object)data.getId()));
            IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
            if (iterator.hasNext()) {
                Product product = (Product)iterator.next();
                ProductData modified = this.include(product, data, errors);
                if (modified == null) continue;
                output.add(modified);
                continue;
            }
            this.addError(errors, data, new ProductIOException(ProductIOException.ErrorCode.ProductNotFound, data.getLine(), new Object[0]));
        }
        return new ProductDataSet(output, errors);
    }

    private ProductData include(Product product, ProductData data, List<ProductData> errors) {
        ProductData result = null;
        if (!StringUtils.equalsIgnoreCase((CharSequence)product.getName(), (CharSequence)data.getName())) {
            this.addError(errors, data, new ProductIOException(ProductIOException.ErrorCode.InvalidName, data.getLine(), product.getName(), data.getName()));
        } else {
            try {
                result = this.comparer.compare(product, data);
            }
            catch (ProductIOException exception) {
                this.addError(errors, data, exception);
            }
        }
        return result;
    }

    private void addError(List<ProductData> errors, ProductData data, ProductIOException error) {
        data.setError(error.getMessage(), error.getLine());
        errors.add(data);
    }
}

