/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.csv.AbstractCSVReader;
import org.openvpms.archetype.csv.CSVException;
import org.openvpms.archetype.csv.CSVReaderException;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.product.io.ProductCSVWriter;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductDataSet;
import org.openvpms.archetype.rules.product.io.ProductIOException;
import org.openvpms.archetype.rules.product.io.ProductReader;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.service.lookup.LookupService;

public class ProductCSVReader
extends AbstractCSVReader
implements ProductReader {
    private final LookupService lookups;
    private List<SimpleDateFormat> formats = ProductCSVReader.getDayMonthYearFormats();
    private static final int ID = 0;
    private static final int NAME = 1;
    private static final int PRINTED_NAME = 2;
    private static final int FIXED_PRICE_ID = 3;
    private static final int FIXED_PRICE = 4;
    private static final int FIXED_COST = 5;
    private static final int FIXED_PRICE_MAX_DISCOUNT = 6;
    private static final int FIXED_PRICE_START_DATE = 7;
    private static final int FIXED_PRICE_END_DATE = 8;
    private static final int DEFAULT_FIXED_PRICE = 9;
    private static final int FIXED_PRICE_GROUPS = 10;
    private static final int UNIT_PRICE_ID = 11;
    private static final int UNIT_PRICE = 12;
    private static final int UNIT_COST = 13;
    private static final int UNIT_PRICE_MAX_DISCOUNT = 14;
    private static final int UNIT_PRICE_START_DATE = 15;
    private static final int UNIT_PRICE_END_DATE = 16;
    private static final int UNIT_PRICE_GROUPS = 17;
    private static final int TAX_RATE = 18;

    public ProductCSVReader(DocumentHandlers handlers, LookupService lookups) {
        super(handlers, ProductCSVWriter.HEADER, ',');
        this.lookups = lookups;
    }

    public void setDateFormats(List<SimpleDateFormat> formats) {
        this.formats = formats;
    }

    public List<SimpleDateFormat> getDateFormats(Document document) {
        ArrayList<SimpleDateFormat> result = new ArrayList<SimpleDateFormat>();
        List<String[]> lines = this.readLines(document);
        LinkedHashSet<String> dates = new LinkedHashSet<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String[] line = lines.get(i);
            int lineNo = i + 2;
            this.checkFields(line, lineNo);
            this.addDate(line, 7, lineNo, dates);
            this.addDate(line, 8, lineNo, dates);
            this.addDate(line, 15, lineNo, dates);
            this.addDate(line, 16, lineNo, dates);
        }
        if (!dates.isEmpty()) {
            result.addAll(this.getDateFormats(dates, ProductCSVReader.getDayMonthYearFormats()));
            result.addAll(this.getDateFormats(dates, ProductCSVReader.getYearMonthDayFormats()));
            result.addAll(this.getDateFormats(dates, ProductCSVReader.getMonthDayYearFormats()));
            if (result.isEmpty()) {
                throw new ProductIOException(ProductIOException.ErrorCode.UnrecognisedDateFormat, -1, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public ProductDataSet read(Document document) {
        ArrayList<ProductData> data = new ArrayList<ProductData>();
        ArrayList<ProductData> errors = new ArrayList<ProductData>();
        ProductDataSet result = new ProductDataSet(data, errors);
        List<String[]> lines = this.readLines(document);
        int lineNo = 2;
        ProductData current = null;
        for (String[] line : lines) {
            current = this.parse(line, current, data, errors, lineNo);
            ++lineNo;
        }
        return result;
    }

    public static List<SimpleDateFormat> getDayMonthYearFormats() {
        return ProductCSVReader.initFormats(new SimpleDateFormat("dd/MM/yy"), new SimpleDateFormat("dd-MM-yy"));
    }

    public static List<SimpleDateFormat> getYearMonthDayFormats() {
        return ProductCSVReader.initFormats(new SimpleDateFormat("yy/MM/dd"), new SimpleDateFormat("yy-MM-dd"));
    }

    public static List<SimpleDateFormat> getMonthDayYearFormats() {
        return ProductCSVReader.initFormats(new SimpleDateFormat("MM/dd/yy"), new SimpleDateFormat("MM-dd-yy"));
    }

    @Override
    protected void checkFields(String[] line, int lineNo) {
        if (line.length < ProductCSVWriter.HEADER.length - 1) {
            throw new CSVReaderException(CSVReaderException.ErrorCode.InvalidLine, lineNo, lineNo, ProductCSVWriter.HEADER.length, line.length);
        }
    }

    private static List<SimpleDateFormat> initFormats(SimpleDateFormat ... formats) {
        ArrayList<SimpleDateFormat> result = new ArrayList<SimpleDateFormat>();
        for (SimpleDateFormat format : formats) {
            format.setLenient(false);
            result.add(format);
        }
        return result;
    }

    private ProductData parse(String[] line, ProductData current, List<ProductData> data, List<ProductData> errors, int lineNo) {
        long id = -1L;
        String name = null;
        String printedName = null;
        BigDecimal tax = null;
        try {
            this.checkFields(line, lineNo);
            id = this.getLong(line, 0, lineNo, true);
            name = this.getName(line, lineNo);
            printedName = this.getString(line, 2, lineNo, false);
            tax = this.getDecimal(line, 18, lineNo, true);
        }
        catch (CSVException exception) {
            ProductData invalid = new ProductData(id, name, printedName, tax, lineNo);
            invalid.setError(exception.getMessage(), exception.getLine());
            errors.add(invalid);
            return null;
        }
        if (current == null || id != current.getId()) {
            current = new ProductData(id, name, printedName, tax, lineNo);
            data.add(current);
        }
        try {
            long fixedId = this.getLong(line, 3, lineNo, false);
            BigDecimal fixedPrice = this.getDecimal(line, 4, lineNo, false);
            BigDecimal fixedCost = this.getDecimal(line, 5, lineNo, fixedPrice != null);
            BigDecimal fixedMaxDiscount = this.getDecimal(line, 6, lineNo, fixedPrice != null);
            Date fixedStartDate = this.getDate(line, 7, lineNo, fixedPrice != null);
            Date fixedEndDate = this.getDate(line, 8, lineNo, false);
            boolean defaultFixedPrice = this.getBoolean(line, 9, lineNo);
            Set<Lookup> fixedPriceGroups = this.getPricingGroups(line, 10, lineNo);
            long unitId = this.getLong(line, 11, lineNo, false);
            BigDecimal unitPrice = this.getDecimal(line, 12, lineNo, false);
            BigDecimal unitCost = this.getDecimal(line, 13, lineNo, unitPrice != null);
            BigDecimal unitMaxDiscount = this.getDecimal(line, 14, lineNo, unitPrice != null);
            Date unitStartDate = this.getDate(line, 15, lineNo, unitPrice != null);
            Date unitEndDate = this.getDate(line, 16, lineNo, false);
            Set<Lookup> unitPriceGroups = this.getPricingGroups(line, 17, lineNo);
            if (fixedPrice != null) {
                current.addFixedPrice(fixedId, fixedPrice, fixedCost, fixedMaxDiscount, fixedStartDate, fixedEndDate, defaultFixedPrice, fixedPriceGroups, lineNo);
            }
            if (unitPrice != null) {
                current.addUnitPrice(unitId, unitPrice, unitCost, unitMaxDiscount, unitStartDate, unitEndDate, unitPriceGroups, lineNo);
            }
        }
        catch (CSVException exception) {
            current.setError(exception.getMessage(), exception.getLine());
            errors.add(current);
            current = null;
        }
        return current;
    }

    private Set<SimpleDateFormat> getDateFormats(Set<String> dates, List<SimpleDateFormat> formats) {
        HashSet<SimpleDateFormat> result = new HashSet<SimpleDateFormat>();
        block2: for (String date : dates) {
            for (SimpleDateFormat format : formats) {
                try {
                    format.parse(date);
                    result.add(format);
                    if (result.size() != formats.size()) continue;
                    continue block2;
                }
                catch (ParseException parseException) {
                }
            }
        }
        return result;
    }

    private void addDate(String[] line, int index, int lineNo, Set<String> dates) {
        String value = this.getString(line, index, lineNo, false);
        if (value != null) {
            dates.add(value);
        }
    }

    private String getName(String[] line, int lineNo) {
        return this.getString(line, 1, lineNo, true);
    }

    private Date getDate(String[] line, int index, int lineNo, boolean required) {
        String value = this.getString(line, index, lineNo, required);
        Date result = null;
        if (value != null) {
            for (DateFormat dateFormat : this.formats) {
                try {
                    result = dateFormat.parse(value);
                    break;
                }
                catch (ParseException parseException) {
                }
            }
            if (result == null) {
                this.reportInvalid(ProductCSVWriter.HEADER[index], value, lineNo);
            }
        }
        return result;
    }

    private Set<Lookup> getPricingGroups(String[] line, int index, int lineNo) {
        HashSet<Lookup> result = new HashSet<Lookup>();
        String[] codes = new String[]{};
        String value = StringUtils.trimToNull((String)line[index]);
        if (value != null) {
            codes = value.split(" ");
        }
        for (String code : codes) {
            Lookup lookup = this.lookups.getLookup("lookup.pricingGroup", code);
            if (lookup == null) {
                this.reportInvalid(ProductCSVWriter.HEADER[index], code, lineNo);
                continue;
            }
            result.add(lookup);
        }
        return result;
    }
}

