/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import java.util.List;
import java.util.Objects;
import org.openvpms.archetype.rules.prefs.PreferenceManager;
import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.prefs.PreferencesImpl;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class PreferenceServiceImpl
implements PreferenceService {
    private final IArchetypeService service;
    private final PlatformTransactionManager transactionManager;

    public PreferenceServiceImpl(IArchetypeService service, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.transactionManager = transactionManager;
    }

    @Override
    public Preferences getPreferences(Party party, Party source, boolean save) {
        Preferences result;
        Reference sourceReference;
        Reference reference = party.getObjectReference();
        Reference reference2 = sourceReference = source != null ? source.getObjectReference() : null;
        if (save) {
            Entity entity = this.getEntity(reference, sourceReference);
            result = new PreferencesImpl(reference, sourceReference, entity, this.service, this.transactionManager);
        } else {
            result = this.getPreferences(reference, sourceReference);
        }
        return result;
    }

    @Override
    public Entity getEntity(Party party, Party source) {
        Reference reference = party.getObjectReference();
        Reference sourceReference = source != null ? source.getObjectReference() : null;
        return this.getEntity(reference, sourceReference);
    }

    @Override
    public void reset(Party party, Party source) {
        final Reference reference = party.getObjectReference();
        final Reference sourceReference = source != null ? source.getObjectReference() : null;
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                PreferenceServiceImpl.this.reset(reference, sourceReference);
            }
        });
    }

    private void reset(Reference party, Reference source) {
        Entity sourcePrefs;
        Entity prefs = this.getEntity(party);
        if (prefs != null) {
            IMObjectBean bean = this.service.getBean((IMObject)prefs);
            List groups = bean.getTargets("groups", IMObject.class);
            List relationships = bean.getValues("groups", EntityLink.class);
            for (EntityLink relationship : relationships) {
                prefs.removeEntityLink(relationship);
            }
            bean.save();
            for (IMObject group : groups) {
                this.service.remove(group);
            }
            this.service.remove((IMObject)prefs);
        }
        if (source != null && !Objects.equals(party, source) && (sourcePrefs = this.getEntity(source)) != null) {
            PreferenceManager.copy(party, sourcePrefs, this.service);
        }
    }

    private Preferences getPreferences(Reference party, Reference source) {
        return PreferenceManager.getPreferences(party, source, this.service);
    }

    private Entity getEntity(Reference party) {
        return PreferenceManager.getEntity(party, this.service);
    }

    private Entity getEntity(Reference party, Reference source) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        Entity result = (Entity)template.execute(status -> {
            Entity sourcePrefs;
            Entity prefs = this.getEntity(party);
            if (prefs == null && source != null && (sourcePrefs = this.getEntity(source)) != null) {
                prefs = PreferenceManager.copy(party, sourcePrefs, this.service);
            }
            if (prefs == null) {
                prefs = (Entity)this.service.create("entity.preferences", Entity.class);
                IMObjectBean bean = this.service.getBean((IMObject)prefs);
                bean.setTarget("user", party);
                bean.save();
            }
            return prefs;
        });
        return result;
    }
}

