/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.HashMap;
import java.util.Map;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ReminderTypes {
    private final Map<Reference, ReminderType> cache = new HashMap<Reference, ReminderType>();
    private final ArchetypeService service;

    public ReminderTypes(ArchetypeService service) {
        this.service = service;
    }

    public ReminderType add(Entity reminderType) {
        ReminderType result = new ReminderType(reminderType, this.service);
        this.cache.put(reminderType.getObjectReference(), result);
        return result;
    }

    public ReminderType get(Reference ref) {
        Entity entity;
        ReminderType result = null;
        if (ref != null && (result = this.cache.get(ref)) == null && (entity = this.load(ref)) != null) {
            result = this.add(entity);
        }
        return result;
    }

    public ReminderType get(Entity entity) {
        return entity != null ? this.get(entity.getObjectReference()) : null;
    }

    private Entity load(Reference ref) {
        return (Entity)this.service.get(ref);
    }
}

