/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ReminderRule {
    private final boolean contact;
    private final boolean email;
    private final boolean sms;
    private final boolean print;
    private final boolean export;
    private final boolean list;
    private final SendTo sendTo;

    public ReminderRule(IMObject rule, ArchetypeService service) {
        IMObjectBean bean = service.getBean(rule);
        this.contact = bean.getBoolean("contact");
        this.email = bean.getBoolean("email");
        this.sms = bean.getBoolean("sms");
        this.print = bean.getBoolean("print");
        this.list = bean.getBoolean("list");
        this.export = bean.getBoolean("export");
        String send = bean.getString("sendTo");
        this.sendTo = SendTo.FIRST.name().equals(send) ? SendTo.FIRST : (SendTo.ALL.name().equals(send) ? SendTo.ALL : SendTo.ANY);
    }

    public boolean isContact() {
        return this.contact;
    }

    public boolean isEmail() {
        return this.email;
    }

    public boolean isSMS() {
        return this.sms;
    }

    public boolean isPrint() {
        return this.print;
    }

    public boolean isExport() {
        return this.export;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean canEmail() {
        return this.isEmail() || this.isContact();
    }

    public boolean canSMS() {
        return this.isSMS() || this.isContact();
    }

    public boolean canPrint() {
        return this.isPrint() || this.isContact();
    }

    public SendTo getSendTo() {
        return this.sendTo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReminderRule) {
            ReminderRule other = (ReminderRule)obj;
            return this.contact == other.contact && this.email == other.email && this.sms == other.sms && this.print == other.print && this.export == other.export && this.list == other.list && this.sendTo == other.sendTo;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.contact).append(this.email).append(this.sms).append(this.print).append(this.export).append(this.list).append((Object)this.sendTo).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        this.append(builder, "contact", this.contact);
        this.append(builder, "email", this.email);
        this.append(builder, "sms", this.sms);
        this.append(builder, "print", this.print);
        this.append(builder, "export", this.export);
        this.append(builder, "list", this.list);
        builder.append("sendTo", (Object)this.sendTo);
        return builder.toString();
    }

    private void append(ToStringBuilder builder, String name, boolean value) {
        if (value) {
            builder.append(name, true);
        }
    }

    public static enum SendTo {
        ALL,
        FIRST,
        ANY;

    }
}

