/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.IdConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;

public class ReminderQuery {
    private final IArchetypeService service;
    private Entity reminderType;
    private Date from;
    private Date to;
    private Party customer;
    private Location location = Location.ALL;
    private static final String START_TIME = "startTime";
    private static final String PATIENT = "patient";
    private static final String REMINDER_TYPE = "reminderType";
    private static final String PRACTICE = "practice";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String ENTITY = "entity";
    private static final String NAME = "name";

    public ReminderQuery(IArchetypeService service) {
        this.service = service;
    }

    public void setReminderType(Entity reminderType) {
        this.reminderType = reminderType;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public void setCustomer(Party customer) {
        this.customer = customer;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Iterable<Act> query() {
        return () -> new IMObjectQueryIterator(this.service, (IArchetypeQuery)this.createQuery());
    }

    public List<Act> execute() {
        ArrayList<Act> result = new ArrayList<Act>();
        for (Act act : this.query()) {
            result.add(act);
        }
        return result;
    }

    public ArchetypeQuery createQuery() {
        String actAlias = "a";
        String patientAlias = "p";
        String customerAlias = "c";
        String ownerAlias = "o";
        String reminderTypeAlias = "r";
        String participationAlias = "powner";
        ShortNameConstraint act = Constraints.shortName((String)"a", (String)"act.patientReminder", (boolean)true);
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)act);
        query.setMaxResults(1000);
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS"));
        query.add((IConstraint)Constraints.join((String)PATIENT, (BaseArchetypeConstraint)Constraints.shortName((String)"powner", (String)"participation.patient", (boolean)true)));
        query.add((IConstraint)new IdConstraint("a", "powner.act"));
        query.add((IConstraint)Constraints.shortName((String)"o", (String)"entityRelationship.patientOwner", (boolean)false));
        query.add((IConstraint)Constraints.shortName((String)"p", (String)"party.patientpet", (boolean)true));
        ShortNameConstraint cust = Constraints.shortName((String)"c", (String)"party.customerperson", (boolean)true);
        if (this.customer != null) {
            cust.add((IConstraint)Constraints.eq((String)"id", (Object)this.customer.getId()));
        }
        if (this.location.getPracticeLocation() != null) {
            cust.add((IConstraint)Constraints.join((String)PRACTICE, (String)"l2").add((IConstraint)Constraints.eq((String)TARGET, (Object)this.location.getPracticeLocation())));
        }
        query.add((IConstraint)cust);
        if (this.location.isNone()) {
            query.add((IConstraint)Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String)"party.customerperson", (String)"c2").add((IConstraint)Constraints.join((String)PRACTICE, (String)"l2").add((IConstraint)Constraints.idEq((String)"c", (String)"c2")))));
        }
        query.add((IConstraint)new IdConstraint("powner.entity", "p"));
        query.add((IConstraint)new IdConstraint("p", "o.target"));
        query.add((IConstraint)new IdConstraint("c", "o.source"));
        query.add((IConstraint)Constraints.sort((String)"c", (String)NAME));
        query.add((IConstraint)Constraints.sort((String)"p", (String)NAME));
        query.add((IConstraint)Constraints.sort((String)"a", (String)START_TIME));
        query.add((IConstraint)Constraints.isNull((String)"o.activeEndTime"));
        ShortNameConstraint reminder = Constraints.shortName((String)"r", (String)"participation.reminderType", (boolean)true);
        if (this.reminderType != null) {
            query.add((IConstraint)Constraints.join((String)REMINDER_TYPE, (BaseArchetypeConstraint)reminder).add((IConstraint)Constraints.eq((String)ENTITY, (Object)this.reminderType)));
        } else {
            query.add((IConstraint)reminder);
            query.add((IConstraint)new IdConstraint("r.act", "a"));
        }
        if (this.from != null) {
            query.add((IConstraint)Constraints.gte((String)START_TIME, (Object)DateRules.getDate(this.from)));
        }
        if (this.to != null) {
            Date tempTo = DateRules.getDate(this.to);
            tempTo = DateRules.getDate(tempTo, 1, DateUnits.DAYS);
            query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)tempTo));
        }
        return query;
    }
}

