/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PurposeMatcher;
import org.openvpms.archetype.rules.party.SMSMatcher;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderCount;
import org.openvpms.archetype.rules.patient.reminder.ReminderProcessorException;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderProcessor {
    private final Date processingDate;
    private final ReminderConfiguration config;
    private final boolean disableSMS;
    private final IArchetypeService service;
    private final PatientRules patientRules;
    private final ReminderTypes reminderTypes;
    private static final Logger log = LoggerFactory.getLogger(ReminderProcessor.class);

    public ReminderProcessor(Date date, ReminderConfiguration config, boolean disableSMS, IArchetypeService service, PatientRules patientRules) {
        this.processingDate = date;
        this.config = config;
        this.disableSMS = disableSMS;
        this.service = service;
        this.patientRules = patientRules;
        this.reminderTypes = new ReminderTypes((ArchetypeService)service);
    }

    public List<Act> process(Act reminder) {
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        int reminderCount = bean.getInt("reminderCount");
        return this.process(reminder, reminderCount, bean, false);
    }

    public List<Act> process(Act reminder, int reminderCount) {
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        return this.process(reminder, reminderCount, bean, true);
    }

    public Act process(Act reminder, int reminderCount, Contact contact) {
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        ReminderType reminderType = this.getReminderType(bean);
        this.checkReminderCount(reminderCount, reminderType);
        ArrayList<Act> toSave = new ArrayList<Act>();
        Date dueDate = reminder.getActivityStartTime();
        Set<Contact> contacts = Collections.singleton(contact);
        if (contact.isA("contact.email")) {
            if (!this.generateEmail(bean, dueDate, contacts, reminderCount, toSave, reminderType)) {
                throw new IllegalStateException("Failed to generate email");
            }
        } else if (contact.isA("contact.phoneNumber")) {
            if (this.disableSMS) {
                throw new IllegalStateException("Cannot process phone contacts. SMS is disabled");
            }
            IMObjectBean contactBean = this.service.getBean((IMObject)contact);
            if (!contactBean.getBoolean("sms")) {
                throw new IllegalArgumentException("Cannot use contact to SMS");
            }
            if (!this.generateSMS(bean, dueDate, contacts, reminderCount, toSave, reminderType)) {
                throw new IllegalStateException("Failed to generate SMS");
            }
        } else if (contact.isA("contact.location")) {
            if (!this.generatePrint(bean, dueDate, contacts, reminderCount, toSave, reminderType)) {
                throw new IllegalStateException("Failed to generate print");
            }
        } else {
            throw new IllegalArgumentException("Invalid archetype for contact: " + contact.getArchetype());
        }
        if (toSave.size() != 1) {
            throw new IllegalStateException("Failed to generate reminder item");
        }
        return toSave.get(0);
    }

    public Party getPatient(Act reminder) {
        return this.getPatient(this.service.getBean((IMObject)reminder));
    }

    public Party getCustomer(Party patient) {
        return this.patientRules.getOwner(patient);
    }

    public ReminderType getReminderType(Act reminder) {
        return this.getReminderType(this.service.getBean((IMObject)reminder));
    }

    private void checkReminderCount(int count, ReminderType reminderType) {
        if (reminderType.getReminderCount(count) == null) {
            throw new ReminderProcessorException(ReminderProcessorException.ErrorCode.NoReminderCount, reminderType.getName(), count);
        }
    }

    private List<Act> generate(Party patient, Party customer, Act reminder, ReminderCount count, ReminderType reminderType) {
        List<Contact> list = Contacts.sort(customer.getContacts());
        HashSet<Contact> found = null;
        DocumentTemplate template = count.getTemplate();
        ReminderRule matchingRule = null;
        for (ReminderRule rule : count.getRules()) {
            HashSet<Contact> matches;
            if (!this.getContacts(rule, list, matches = new HashSet<Contact>(), template, count, reminderType, customer)) continue;
            found = matches;
            matchingRule = rule;
            break;
        }
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        ArrayList<Act> toSave = new ArrayList<Act>();
        Date dueDate = reminder.getActivityStartTime();
        if (matchingRule != null) {
            this.generate(bean, dueDate, patient, customer, count, reminderType, found, matchingRule, toSave);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("NO matching rule for customer=" + this.toString((Entity)customer) + ", patient=" + this.toString((Entity)patient) + ", reminderType=" + reminderType.getName() + ", count=" + count.getCount() + ". Reminder will be Listed");
            }
            String message = new ReminderProcessorException(ReminderProcessorException.ErrorCode.NoContactsForRules, new Object[0]).getMessage();
            this.generateList(bean, dueDate, count.getCount(), message, toSave, reminderType);
        }
        return toSave;
    }

    private void generate(IMObjectBean bean, Date dueDate, Party patient, Party customer, ReminderCount count, ReminderType reminderType, Set<Contact> contacts, ReminderRule rule, List<Act> toSave) {
        ReminderRule.SendTo sendTo;
        if (log.isDebugEnabled()) {
            log.debug("Found matching rule for customer=" + this.toString((Entity)customer) + ", patient=" + this.toString((Entity)patient) + ", reminderType=" + reminderType.getName() + ", count=" + count.getCount() + ", rule=" + rule + ", contacts=" + this.toString(contacts));
        }
        if ((sendTo = rule.getSendTo()) == ReminderRule.SendTo.ALL || sendTo == ReminderRule.SendTo.ANY) {
            if (rule.canEmail()) {
                this.generateEmail(bean, dueDate, contacts, count.getCount(), toSave, reminderType);
            }
            if (!this.disableSMS && rule.canSMS()) {
                this.generateSMS(bean, dueDate, contacts, count.getCount(), toSave, reminderType);
            }
            if (rule.canPrint()) {
                this.generatePrint(bean, dueDate, contacts, count.getCount(), toSave, reminderType);
            }
        } else {
            boolean generated;
            boolean bl = generated = rule.canEmail() && this.generateEmail(bean, dueDate, contacts, count.getCount(), toSave, reminderType);
            if (!generated) {
                boolean bl2 = generated = !this.disableSMS && rule.canSMS() && this.generateSMS(bean, dueDate, contacts, count.getCount(), toSave, reminderType);
                if (!generated && rule.canPrint()) {
                    this.generatePrint(bean, dueDate, contacts, count.getCount(), toSave, reminderType);
                }
            }
        }
        if (rule.isExport()) {
            this.generateExport(bean, dueDate, contacts, count.getCount(), toSave, reminderType);
        }
        if (rule.isList()) {
            this.generateList(bean, dueDate, count.getCount(), null, toSave, reminderType);
        }
    }

    private List<Act> process(Act reminder, int reminderCount, IMObjectBean bean, boolean ignoreDueDate) {
        Party customer;
        Party patient;
        ReminderType reminderType = this.getReminderType(bean);
        Date dueDate = reminder.getActivityStartTime();
        List<Act> result = !reminderType.isActive() ? this.cancelInactiveReminderType(reminder, bean, reminderType) : (!ignoreDueDate && reminderType.shouldCancel(dueDate, this.processingDate) ? this.cancelExpiredReminder(reminder, bean, reminderType, dueDate) : (!(patient = this.getPatient(bean)).isActive() || this.patientRules.isDeceased(patient) ? this.cancelForInactiveOrDeceased(reminder, reminderType, patient) : ((customer = this.getCustomer(patient)) == null ? this.cancelForInactiveOrMissingCustomer(reminder, reminderType, patient) : this.process(reminder, reminderCount, reminderType, dueDate, patient, customer))));
        return result;
    }

    private List<Act> process(Act reminder, int reminderCount, ReminderType reminderType, Date dueDate, Party patient, Party customer) {
        List<Act> result;
        ReminderCount count = reminderType.getReminderCount(reminderCount);
        if (count != null) {
            result = this.generate(patient, customer, reminder, count, reminderType);
        } else if (reminderCount == 0) {
            result = new ArrayList();
            String error = new ReminderProcessorException(ReminderProcessorException.ErrorCode.NoReminderCount, reminderType.getName(), reminderCount).getMessage();
            this.generateList(this.service.getBean((IMObject)reminder), dueDate, reminderCount, error, result, reminderType);
        } else {
            result = Collections.emptyList();
            if (log.isDebugEnabled()) {
                log.debug("Skipping reminder=" + reminder.getId() + ", patient=" + this.toString((Entity)patient) + ", reminderType=" + this.toString(reminderType) + ": no reminder count=" + reminderCount);
            }
        }
        return result;
    }

    private List<Act> cancelForInactiveOrMissingCustomer(Act reminder, ReminderType reminderType, Party patient) {
        if (log.isDebugEnabled()) {
            log.debug("Cancelling reminder=" + reminder.getId() + ", patient=" + patient + ", reminderType=" + this.toString(reminderType) + ": no customer, or customer inactive");
        }
        List<Act> result = this.cancel(reminder);
        return result;
    }

    private List<Act> cancelInactiveReminderType(Act reminder, IMObjectBean bean, ReminderType reminderType) {
        if (log.isDebugEnabled()) {
            log.debug("Cancelling reminder=" + reminder.getId() + ", patient=" + this.getPatientId(bean) + ", reminderType=" + this.toString(reminderType) + ": reminder type is inactive");
        }
        List<Act> result = this.cancel(reminder);
        return result;
    }

    private List<Act> cancelExpiredReminder(Act reminder, IMObjectBean bean, ReminderType reminderType, Date dueDate) {
        if (log.isDebugEnabled()) {
            log.debug("Cancelling reminder=" + reminder.getId() + ", patient=" + this.getPatientId(bean) + ", reminderType=" + this.toString(reminderType) + ", firstDueDate=" + this.toString(dueDate) + ", processingDate=" + this.toString(this.processingDate) + ", cancelDate=" + this.toString(reminderType.getCancelDate(dueDate)) + ": firstDueDate <= cancelDate");
        }
        List<Act> result = this.cancel(reminder);
        return result;
    }

    private List<Act> cancelForInactiveOrDeceased(Act reminder, ReminderType reminderType, Party patient) {
        if (log.isDebugEnabled()) {
            if (!patient.isActive()) {
                log.debug("Cancelling reminder=" + reminder.getId() + ", patient=" + this.toString((Entity)patient) + ", reminderType=" + this.toString(reminderType) + ": patient is inactive");
            } else {
                log.debug("Cancelling reminder=" + reminder.getId() + ", patient=" + this.toString((Entity)patient) + ", reminderType=" + this.toString(reminderType) + ": patient is deceased");
            }
        }
        List<Act> result = this.cancel(reminder);
        return result;
    }

    private Party getPatient(IMObjectBean bean) {
        Party patient = (Party)bean.getTarget("patient", Party.class);
        if (patient == null) {
            throw new ReminderProcessorException(ReminderProcessorException.ErrorCode.NoPatient, new Object[0]);
        }
        return patient;
    }

    private boolean generateEmail(IMObjectBean reminder, Date dueDate, Set<Contact> contacts, int count, List<Act> toSave, ReminderType reminderType) {
        boolean result = false;
        if (this.hasContact("contact.email", contacts)) {
            this.createItem("act.patientReminderItemEmail", this.config.getEmailSendDate(dueDate), reminder, count, null, toSave, reminderType);
            result = true;
        } else if (log.isDebugEnabled()) {
            log.debug("NOT generating email reminder for reminder=" + reminder.getObject().getId() + ", patient=" + this.getPatientId(reminder) + ", reminderType=" + this.toString(reminderType) + ": customer has no email contact");
        }
        return result;
    }

    private boolean generateSMS(IMObjectBean reminder, Date dueDate, Set<Contact> contacts, int count, List<Act> toSave, ReminderType reminderType) {
        boolean result = false;
        if (Contacts.find(contacts, new SMSMatcher((IMObjectBeanFactory)this.service)) != null) {
            this.createItem("act.patientReminderItemSMS", this.config.getSMSSendDate(dueDate), reminder, count, null, toSave, reminderType);
            result = true;
        } else if (log.isDebugEnabled()) {
            log.debug("NOT generating SMS reminder for reminder=" + reminder.getObject().getId() + ", patient=" + this.getPatientId(reminder) + ", reminderType=" + this.toString(reminderType) + ": customer has no SMS contact");
        }
        return result;
    }

    private boolean generatePrint(IMObjectBean reminder, Date dueDate, Set<Contact> contacts, int count, List<Act> toSave, ReminderType reminderType) {
        boolean result = false;
        if (this.hasContact("contact.location", contacts)) {
            this.createItem("act.patientReminderItemPrint", this.config.getPrintSendDate(dueDate), reminder, count, null, toSave, reminderType);
            result = true;
        } else if (log.isDebugEnabled()) {
            log.debug("NOT generating print reminder for reminder=" + reminder.getObject().getId() + ", patient=" + this.getPatientId(reminder) + ", reminderType=" + this.toString(reminderType) + ": customer has no location contact");
        }
        return result;
    }

    private boolean generateExport(IMObjectBean reminder, Date dueDate, Set<Contact> contacts, int count, List<Act> toSave, ReminderType reminderType) {
        boolean result = false;
        if (this.hasContact("contact.location", contacts)) {
            this.createItem("act.patientReminderItemExport", this.config.getExportSendDate(dueDate), reminder, count, null, toSave, reminderType);
            result = true;
        } else if (log.isDebugEnabled()) {
            log.debug("NOT generating export reminder for reminder=" + reminder.getObject().getId() + ", patient=" + this.getPatientId(reminder) + ", reminderType=" + this.toString(reminderType) + ": customer has no location contact");
        }
        return result;
    }

    private Act generateList(IMObjectBean reminder, Date dueDate, int count, String error, List<Act> toSave, ReminderType reminderType) {
        return this.createItem("act.patientReminderItemList", this.config.getListSendDate(dueDate), reminder, count, error, toSave, reminderType);
    }

    private boolean hasContact(String shortName, Set<Contact> contacts) {
        for (Contact contact : contacts) {
            if (!TypeHelper.isA((IMObject)contact, (String)shortName)) continue;
            return true;
        }
        return false;
    }

    private Act createItem(String shortName, Date startTime, IMObjectBean reminder, int count, String error, List<Act> toSave, ReminderType reminderType) {
        Act act = (Act)this.service.create(shortName, Act.class);
        act.setActivityStartTime(DateRules.getDate(startTime));
        act.setActivityEndTime(reminder.getDate("endTime"));
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setValue("count", (Object)count);
        if (error != null) {
            bean.setValue("error", (Object)error);
            act.setStatus("ERROR");
        } else {
            act.setStatus("PENDING");
        }
        if (log.isDebugEnabled()) {
            log.debug("Generating " + shortName + ", reminder=" + reminder.getObject().getId() + ", patient=" + this.getPatientId(reminder) + ", reminderType=" + this.toString(reminderType) + ", send=" + this.toString(act.getActivityStartTime()) + ", due=" + this.toString(act.getActivityEndTime()) + ", count=" + count + ", error=" + error);
        }
        reminder.addTarget("items", (IMObject)act, "reminder");
        toSave.add(act);
        return act;
    }

    private boolean getContacts(ReminderRule rule, List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType, Party customer) {
        boolean result;
        boolean isAll;
        ReminderRule.SendTo sendTo = rule.getSendTo();
        boolean bl = isAll = sendTo == ReminderRule.SendTo.ALL;
        if (!contacts.isEmpty()) {
            if (!this.processContactRule(rule, contacts, matches, template, count, reminderType, customer, isAll)) {
                return false;
            }
            if (!this.processEmailRule(rule, contacts, matches, template, count, reminderType, customer, isAll)) {
                return false;
            }
            if (!this.processSMSRule(rule, contacts, matches, template, count, reminderType, customer, isAll)) {
                return false;
            }
            if (!this.processPrintRule(rule, contacts, matches, template, count, reminderType, customer, isAll)) {
                return false;
            }
        }
        if (rule.isExport()) {
            this.addContact("contact.location", contacts, matches);
        } else if (rule.isList()) {
            this.addContact("contact.phoneNumber", contacts, matches);
        }
        boolean bl2 = result = !matches.isEmpty();
        if (!result && log.isDebugEnabled()) {
            log.debug("Rule not matched. No contacts match reminderType=" + this.toString(reminderType) + ", count=" + count.getCount() + ", rule=" + rule);
        }
        return result;
    }

    private boolean processContactRule(ReminderRule rule, List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType, Party customer, boolean isAll) {
        if (rule.isContact() && !this.addReminderContacts(contacts, matches, template, count, reminderType) && isAll) {
            if (log.isDebugEnabled()) {
                log.debug("Rule not matched. There are no REMINDER contacts for customer=" + this.toString((Entity)customer) + ", reminderType=" + this.toString(reminderType) + ", count=" + count.getCount() + ", rule=" + rule);
            }
            return false;
        }
        return true;
    }

    private boolean processEmailRule(ReminderRule rule, List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType, Party customer, boolean isAll) {
        if (rule.isEmail() && !this.addEmailContact(contacts, matches, template, count, reminderType) && isAll) {
            if (log.isDebugEnabled()) {
                log.debug("Rule not matched. There are no email contacts for customer=" + this.toString((Entity)customer) + ", reminderType=" + this.toString(reminderType) + ", count=" + count.getCount() + ", rule=" + rule);
            }
            return false;
        }
        return true;
    }

    private boolean processSMSRule(ReminderRule rule, List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType, Party customer, boolean isAll) {
        if (rule.isSMS()) {
            if (isAll && this.disableSMS) {
                if (log.isDebugEnabled()) {
                    log.debug("Rule not matched. SMS has been disabled for customer=" + this.toString((Entity)customer) + ", reminderType=" + this.toString(reminderType) + ", count=" + count.getCount() + ", rule=" + rule);
                }
                return false;
            }
            if (!this.addSMSContact(contacts, matches, template, count, reminderType) && isAll) {
                if (log.isDebugEnabled()) {
                    log.debug("Rule not matched. There are no SMS contacts for customer=" + this.toString((Entity)customer) + ", reminderType=" + this.toString(reminderType) + ", count=" + count.getCount() + ", rule=" + rule);
                }
                return false;
            }
        }
        return true;
    }

    private boolean processPrintRule(ReminderRule rule, List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType, Party customer, boolean isAll) {
        if (rule.isPrint() && !this.addLocationContact(contacts, matches, template, count, reminderType) && isAll) {
            if (log.isDebugEnabled()) {
                log.debug("Rule not matched. There are no location contacts for customer=" + this.toString((Entity)customer) + ", reminderType=" + this.toString(reminderType) + ", count=" + count.getCount() + ", rule=" + rule);
            }
            return false;
        }
        return true;
    }

    private ReminderType getReminderType(IMObjectBean bean) {
        Reference ref = bean.getTargetRef("reminderType");
        ReminderType reminderType = this.reminderTypes.get(ref);
        if (reminderType == null) {
            throw new ReminderProcessorException(ReminderProcessorException.ErrorCode.NoReminderType, new Object[0]);
        }
        return reminderType;
    }

    private List<Act> cancel(Act reminder) {
        reminder.setStatus("CANCELLED");
        ArrayList<Act> toSave = new ArrayList<Act>();
        toSave.add(reminder);
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        for (Act item : bean.getTargets("items", Act.class)) {
            if ("COMPLETED".equals(item.getStatus())) continue;
            item.setStatus("CANCELLED");
            toSave.add(item);
        }
        return toSave;
    }

    private boolean addReminderContacts(List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType) {
        int size = matches.size();
        if (template != null) {
            this.addReminderSMSContacts(contacts, matches, template, count, reminderType);
            this.addContact(contacts, matches, new PurposeMatcher("contact.location", "REMINDER", true, (IMObjectBeanFactory)this.service));
            this.addReminderEmailContacts(contacts, matches, template, count, reminderType);
        } else if (log.isDebugEnabled()) {
            log.debug("NOT adding REMINDER contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". ReminderCount has no template");
        }
        return size != matches.size();
    }

    private void addReminderSMSContacts(List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType) {
        if (!this.disableSMS && template.getSMSTemplate() != null) {
            this.addContact(contacts, matches, new SMSMatcher("REMINDER", true, (IMObjectBeanFactory)this.service));
        } else if (log.isDebugEnabled()) {
            if (this.disableSMS) {
                log.debug("NOT adding SMS contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". SMS is disabled");
            } else {
                log.debug("NOT adding SMS contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". Template=" + template.getName() + " has no SMS template");
            }
        }
    }

    private void addReminderEmailContacts(List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType) {
        if (template.getEmailTemplate() != null) {
            this.addContact(contacts, matches, new PurposeMatcher("contact.email", "REMINDER", true, (IMObjectBeanFactory)this.service));
        } else {
            log.debug("NOT adding email contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". Template=" + template.getName() + " has no email template");
        }
    }

    private boolean addEmailContact(List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType) {
        boolean result = false;
        if (template != null) {
            if (template.getEmailTemplate() != null) {
                result = this.addContact("contact.email", contacts, matches);
            } else if (log.isDebugEnabled()) {
                log.debug("NOT adding email contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". Template=" + template.getName() + " has no email template");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("NOT adding email contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". ReminderCount has no template");
        }
        return result;
    }

    private boolean addSMSContact(List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType) {
        boolean result = false;
        if (template != null) {
            if (template.getSMSTemplate() != null) {
                result = this.addContact(contacts, matches, new SMSMatcher("REMINDER", false, (IMObjectBeanFactory)this.service));
            } else if (log.isDebugEnabled()) {
                log.debug("NOT adding SMS contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". Template=" + template.getName() + " has no SMS template");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("NOT adding SMS contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". ReminderCount has no template");
        }
        return result;
    }

    private boolean addLocationContact(List<Contact> contacts, Set<Contact> matches, DocumentTemplate template, ReminderCount count, ReminderType reminderType) {
        boolean result = false;
        if (template != null) {
            result = this.addContact("contact.location", contacts, matches);
        } else if (log.isDebugEnabled()) {
            log.debug("NOT adding location contacts for reminderType=" + this.toString(reminderType) + ", reminderCount=" + count.getCount() + ". ReminderCount has no template");
        }
        return result;
    }

    private boolean addContact(String shortName, List<Contact> contacts, Set<Contact> matches) {
        PurposeMatcher matcher = new PurposeMatcher(shortName, "REMINDER", false, (IMObjectBeanFactory)this.service);
        return this.addContact(contacts, matches, matcher);
    }

    private boolean addContact(List<Contact> contacts, Set<Contact> matches, PurposeMatcher matcher) {
        Contact contact = Contacts.find(contacts, matcher);
        if (contact != null) {
            matches.add(contact);
            return true;
        }
        return false;
    }

    private String toString(ReminderType reminderType) {
        return reminderType != null ? this.toString(reminderType.getEntity()) : null;
    }

    private String toString(Entity entity) {
        return entity != null ? entity.getName() + " (" + entity.getId() + ")" : null;
    }

    private String toString(Date date) {
        return new Timestamp(date.getTime()).toString();
    }

    private String getPatientId(IMObjectBean reminder) {
        Reference patient = reminder.getTargetRef("patient");
        return patient != null ? Long.toString(patient.getId()) : null;
    }

    private String toString(Set<Contact> contacts) {
        StringBuilder result = new StringBuilder();
        for (Contact contact : contacts) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(contact.getDescription());
        }
        return result.toString();
    }
}

