/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ReminderCount {
    private final int count;
    private final int interval;
    private final DateUnits units;
    private final List<ReminderRule> rules = new ArrayList<ReminderRule>();
    private final IMObjectBean bean;
    private DocumentTemplate template;
    private final ArchetypeService service;

    public ReminderCount(IMObject object, ArchetypeService service) {
        this.bean = service.getBean(object);
        this.service = service;
        this.count = this.bean.getInt("count");
        this.interval = this.bean.getInt("interval");
        this.units = DateUnits.fromString(this.bean.getString("units"), DateUnits.DAYS);
    }

    public int getCount() {
        return this.count;
    }

    public int getInterval() {
        return this.interval;
    }

    public DateUnits getUnits() {
        return this.units;
    }

    public Date getNextDueDate(Date dueDate) {
        return DateRules.getDate(dueDate, this.interval, this.units);
    }

    public List<ReminderRule> getRules() {
        if (this.rules.isEmpty()) {
            for (IMObject rule : this.bean.getTargets("rules", Policies.orderBySequence())) {
                this.rules.add(new ReminderRule(rule, this.service));
            }
        }
        return this.rules;
    }

    public DocumentTemplate getTemplate() {
        IMObject object;
        if (this.template == null && (object = this.bean.getTarget("template")) != null) {
            this.template = new DocumentTemplate((Entity)object, this.service);
        }
        return this.template;
    }
}

