/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.commons.collections4.ComparatorUtils;
import org.openvpms.archetype.rules.patient.PatientAgeFormatter;
import org.openvpms.archetype.rules.patient.PatientMerger;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.ArchetypeServiceFunctions;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.IterableIMObjectQuery;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ParticipationConstraint;

public class PatientRules {
    public static final String SEX_MALE = "MALE";
    public static final String SEX_FEMALE = "FEMALE";
    public static final String SEX_UNSPECIFIED = "UNSPECIFIED";
    public static final String ALLERGY_ALERT_TYPE = "ALLERGY";
    public static final String AGGRESSION_ALERT_TYPE = "AGGRESSION";
    private final PracticeRules rules;
    private final PracticeService practiceService;
    private final IArchetypeService service;
    private final LookupService lookups;
    private final ArchetypeServiceFunctions functions;
    private PatientAgeFormatter formatter;
    private static final String COLOUR = "colour";
    private static final String CUSTOMERS = "customers";
    private static final String ACTIVE = "active";
    private static final String DECEASED = "deceased";
    private static final String DECEASED_DATE = "deceasedDate";
    private static final String DESEXED = "desexed";
    private static final String PATIENT = "patient";
    private static final String ENTITY = "entity";
    private static final String START_TIME = "startTime";

    public PatientRules(PracticeRules rules, PracticeService practiceService, IArchetypeService service, LookupService lookups) {
        this(rules, practiceService, service, lookups, null);
    }

    public PatientRules(PracticeRules rules, PracticeService practiceService, IArchetypeService service, LookupService lookups, PatientAgeFormatter formatter) {
        this.rules = rules;
        this.service = service;
        this.practiceService = practiceService;
        this.lookups = lookups;
        this.formatter = formatter;
        this.functions = new ArchetypeServiceFunctions(service, lookups);
    }

    public EntityRelationship addPatientOwnerRelationship(Party customer, Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)customer);
        EntityRelationship relationship = (EntityRelationship)bean.addTarget("patients", "entityRelationship.patientOwner", (IMObject)patient);
        patient.addEntityRelationship(relationship);
        relationship.setActiveStartTime(new Date());
        return relationship;
    }

    public EntityRelationship addPatientLocationRelationship(Party customer, Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)customer);
        EntityRelationship relationship = (EntityRelationship)bean.addTarget("patients", "entityRelationship.patientLocation", (IMObject)patient);
        patient.addEntityRelationship(relationship);
        relationship.setActiveStartTime(new Date());
        return relationship;
    }

    public Party getOwner(Act act) {
        Party patient = this.getPatient(act);
        return patient != null ? this.getOwner(patient, act.getActivityStartTime(), false) : null;
    }

    public Party getOwner(Party patient) {
        return this.getOwner(patient, new Date(), true);
    }

    public Party getCurrentOwner(Act act) {
        Party patient = this.getPatient(act);
        return patient != null ? this.getOwner(patient, new Date(), true) : null;
    }

    public Party getOwner(Party patient, Date startTime, boolean active) {
        return this.getSourceParty(patient, startTime, active, "entityRelationship.patientOwner");
    }

    public Reference getOwnerReference(Party patient) {
        return this.getOwnerReference(patient, new Date());
    }

    public Reference getOwnerReference(Party patient, Date startTime) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        Predicate isA = Predicates.isA((String[])new String[]{"entityRelationship.patientOwner"});
        Relationship er = (Relationship)bean.getValue(CUSTOMERS, Relationship.class, isA.and(Predicates.activeAt((Date)startTime)));
        return er != null && er.isActive() ? er.getSource() : null;
    }

    public boolean isOwner(Party customer, Party patient) {
        Party owner = this.getOwner(patient);
        return owner != null && owner.equals(customer);
    }

    public Party getLocation(Act act) {
        Party patient = this.getPatient(act);
        Date startTime = act.getActivityStartTime();
        return this.getLocation(patient, startTime, false);
    }

    public Party getLocation(Party patient) {
        return this.getLocation(patient, new Date(), true);
    }

    public Party getCurrentLocation(Act act) {
        Party patient = this.getPatient(act);
        return patient != null ? this.getLocation(patient, new Date(), true) : null;
    }

    public Party getLocation(Party patient, Date startTime, boolean active) {
        return this.getSourceParty(patient, startTime, active, "entityRelationship.patientLocation");
    }

    public Party getReferralVet(Party patient, Date time) {
        return this.getReferralVet(patient, time, true);
    }

    public Party getReferralVet(Party patient, Date time, boolean active) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        return (Party)bean.getTarget("referrals", Party.class, Policies.active((Date)time, (boolean)active));
    }

    public void setInactive(Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        if (bean.getBoolean(ACTIVE)) {
            bean.setValue(ACTIVE, (Object)false);
            this.service.save((IMObject)patient);
        }
    }

    public void setDeceased(Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        if (!bean.getBoolean(DECEASED)) {
            bean.setValue(DECEASED, (Object)true);
            bean.setValue(ACTIVE, (Object)false);
            if (bean.hasNode(DECEASED_DATE)) {
                bean.setValue(DECEASED_DATE, (Object)new Date());
            }
            this.service.save((IMObject)patient);
        }
    }

    public boolean isDeceased(Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        return bean.getBoolean(DECEASED);
    }

    public void setDesexed(Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        if (!bean.getBoolean(DESEXED)) {
            bean.setValue(DESEXED, (Object)true);
            this.service.save((IMObject)patient);
        }
    }

    public boolean isDesexed(Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        return bean.getBoolean(DESEXED);
    }

    public String getPatientDesexStatus(Party patient) {
        if (patient != null) {
            if (this.isDesexed(patient)) {
                return "Desexed";
            }
            return "Entire";
        }
        return "";
    }

    public Date getDateOfBirth(Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        return bean.getDate("dateOfBirth");
    }

    public String getPatientAge(Party patient) {
        return this.getPatientAge(patient, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPatientAge(Party patient, Date date) {
        String result;
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        Date birthDate = bean.getDate("dateOfBirth");
        Date deceasedDate = bean.getDate(DECEASED_DATE);
        PatientRules patientRules = this;
        synchronized (patientRules) {
            if (this.formatter == null) {
                this.formatter = new PatientAgeFormatter(this.lookups, this.rules, (ArchetypeService)this.service);
            }
        }
        if (deceasedDate == null) {
            result = this.formatter.format(birthDate, date);
        } else {
            if (DateRules.compareTo(deceasedDate, date) < 0) {
                date = deceasedDate;
            }
            result = this.formatter.format(birthDate, date);
        }
        return result;
    }

    public String getPatientSpecies(Party patient) {
        return this.functions.lookup((IMObject)patient, "species");
    }

    public String getPatientBreed(Party patient) {
        return this.functions.lookup((IMObject)patient, "breed");
    }

    public String getPatientSex(Party patient) {
        return this.functions.lookup((IMObject)patient, "sex");
    }

    public String getPatientColour(Party patient) {
        String result = null;
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        if (bean.getNode(COLOUR).isLookup()) {
            Lookup colour = bean.getLookup(COLOUR);
            if (colour != null) {
                result = colour.getName();
            }
        } else {
            result = bean.getString(COLOUR);
        }
        return result;
    }

    public String getPatientWeight(Party patient) {
        ObjectSet set;
        String result = null;
        ArchetypeQuery query = this.createWeightQuery(patient);
        query.add((IConstraint)new NodeSelectConstraint("act.description"));
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        ObjectSet objectSet = set = iterator.hasNext() ? (ObjectSet)iterator.next() : null;
        if (set != null) {
            result = (String)set.get("act.description");
        }
        return result;
    }

    public Weight getWeight(Party patient) {
        Weight weight;
        Act act = this.getWeightAct(patient);
        if (act != null) {
            weight = this.getWeight(act);
        } else {
            WeightUnits units = this.practiceService.getDefaultWeightUnits();
            weight = new Weight(BigDecimal.ZERO, units);
        }
        return weight;
    }

    public Weight getWeight(Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        String units = bean.getString("units", WeightUnits.KILOGRAMS.toString());
        return new Weight(bean.getBigDecimal("weight", BigDecimal.ZERO), WeightUnits.valueOf((String)units), act.getActivityStartTime());
    }

    public Act getWeightAct(Party patient) {
        ArchetypeQuery query = this.createWeightQuery(patient);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (Act)iterator.next() : null;
    }

    public String getMicrochipNumber(Party patient) {
        return this.getIdentity(patient, "entityIdentity.microchip");
    }

    public String getMicrochipNumbers(Party patient) {
        StringBuilder result = null;
        Collection<Identity> identities = this.getIdentities(patient, "entityIdentity.microchip");
        for (Identity identity : identities) {
            if (result == null) {
                result = new StringBuilder(identity.getIdentity());
                continue;
            }
            result.append(", ").append(identity.getIdentity());
        }
        return result != null ? result.toString() : null;
    }

    public EntityIdentity getMicrochip(Party patient) {
        return this.getEntityIdentity(patient, "entityIdentity.microchip");
    }

    public String getPetTag(Party patient) {
        return this.getIdentity(patient, "entityIdentity.petTag");
    }

    public String getRabiesTag(Party patient) {
        return this.getIdentity(patient, "entityIdentity.rabiesTag");
    }

    public void mergePatients(Party from, Party to) {
        PatientMerger merger = new PatientMerger(this.service);
        merger.merge(from, to);
    }

    public Iterable<Act> getAlerts(Party patient) {
        ArchetypeQuery query = this.createAlertQuery(patient, null, new Date());
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public List<Act> getAllergies(Party patient, Date date) {
        ArrayList<Act> acts = new ArrayList<Act>();
        ArchetypeQuery query = this.createAlertQuery(patient, ALLERGY_ALERT_TYPE, date);
        IMObjectQueryIterator alerts = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        while (alerts.hasNext()) {
            acts.add((Act)alerts.next());
        }
        return acts;
    }

    public boolean isAllergy(Act alert) {
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)alert);
        Entity alertType = (Entity)bean.getTarget("alertType", Entity.class);
        if (alertType != null) {
            IMObjectBean alertBean = this.service.getBean((IMObject)alertType);
            IMObject lookup = alertBean.getValue("class", IMObject.class, object -> object instanceof Lookup && ALLERGY_ALERT_TYPE.equals(((Lookup)object).getCode()));
            result = lookup != null;
        }
        return result;
    }

    public boolean isAggressive(Party patient) {
        ArchetypeQuery query = this.createAlertQuery(patient, AGGRESSION_ALERT_TYPE, new Date());
        query.setMaxResults(1);
        IMObjectQueryIterator alerts = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return alerts.hasNext();
    }

    public Collection<Identity> getIdentities(Party patient, String shortName) {
        TreeMap<Long, EntityIdentity> result = new TreeMap<Long, EntityIdentity>(ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator()));
        for (EntityIdentity identity : patient.getIdentities()) {
            if (!identity.isActive() || !identity.isA(shortName)) continue;
            result.put(identity.getId(), identity);
        }
        return result.values();
    }

    public EntityIdentity getEntityIdentity(Party patient, String shortName) {
        EntityIdentity result = null;
        if (patient != null) {
            for (EntityIdentity identity : patient.getIdentities()) {
                if (!identity.isActive() || !identity.isA(shortName) || result != null && result.getId() >= identity.getId()) continue;
                result = identity;
            }
        }
        return result;
    }

    private Party getPatient(Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.hasNode(PATIENT) ? (Party)bean.getTarget(PATIENT, Party.class) : null;
    }

    private Party getSourceParty(Party patient, Date startTime, boolean active, String shortName) {
        IMObjectBean bean;
        Party result = null;
        if (patient != null && startTime != null && (result = this.getSourcePartyAtTime(bean = this.service.getBean((IMObject)patient), startTime, active, shortName)) == null && !active) {
            result = this.getSourcePartyClosestToTime(bean, startTime, shortName);
        }
        return result;
    }

    private Party getSourcePartyAtTime(IMObjectBean bean, Date startTime, boolean active, String shortName) {
        Predicate predicate = Predicates.activeAt((Date)startTime).and(Predicates.isA((String[])new String[]{shortName}));
        Policy policy = Policies.match((boolean)active, predicate);
        Party result = (Party)bean.getSource(CUSTOMERS, Party.class, policy);
        return result;
    }

    private Party getSourcePartyClosestToTime(IMObjectBean bean, Date startTime, String shortName) {
        Party result = null;
        EntityRelationship match = null;
        List relationships = bean.getValues(CUSTOMERS, EntityRelationship.class, Predicates.isA((String[])new String[]{shortName}));
        for (EntityRelationship relationship : relationships) {
            Party party;
            if (match == null) {
                result = this.get(relationship.getSource());
                if (result == null) continue;
                match = relationship;
                continue;
            }
            if (!this.closerTime(startTime, relationship, match) || (party = this.get(relationship.getSource())) == null) continue;
            result = party;
            match = relationship;
        }
        return result;
    }

    private ArchetypeQuery createAlertQuery(Party patient, String code, Date date) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientAlert");
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS"));
        query.add((IConstraint)Constraints.join((String)PATIENT).add((IConstraint)Constraints.eq((String)ENTITY, (Object)patient)));
        if (code != null) {
            query.add((IConstraint)Constraints.join((String)"alertType").add((IConstraint)Constraints.join((String)ENTITY).add((IConstraint)Constraints.join((String)"class", (String)"clazz").add((IConstraint)Constraints.eq((String)"code", (Object)code)))));
        }
        query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.lte((String)START_TIME, (Object)date), Constraints.or((IConstraint[])new IConstraint[]{Constraints.gt((String)"endTime", (Object)date), Constraints.isNull((String)"endTime")})}));
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        query.add((IConstraint)Constraints.sort((String)"id"));
        return query;
    }

    private ArchetypeQuery createWeightQuery(Party patient) {
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"act", (String)"act.patientWeight"));
        JoinConstraint participation = Constraints.join((String)PATIENT);
        participation.add((IConstraint)Constraints.eq((String)ENTITY, (Object)patient));
        participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientWeight"));
        query.add((IConstraint)participation);
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)false));
        query.setMaxResults(1);
        return query;
    }

    private boolean closerTime(Date startTime, EntityRelationship r1, EntityRelationship r2) {
        long diff2;
        long time = this.getTime(startTime);
        long diff1 = Math.abs(time - this.getTime(r1.getActiveStartTime()));
        return diff1 < (diff2 = Math.abs(time - this.getTime(r2.getActiveStartTime())));
    }

    private long getTime(Date date) {
        return date != null ? date.getTime() : 0L;
    }

    private Party get(Reference ref) {
        if (ref != null) {
            return (Party)this.service.get(ref);
        }
        return null;
    }

    private String getIdentity(Party patient, String shortName) {
        EntityIdentity result = this.getEntityIdentity(patient, shortName);
        return result != null ? result.getIdentity() : null;
    }
}

