/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Date;
import java.util.HashMap;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.NamedQuery;

public class PatientRelationshipRules {
    private PatientRelationshipRules() {
    }

    public static void checkRelationships(Party patient) {
        HashMap<String, EntityRelationship> currentActives = new HashMap<String, EntityRelationship>();
        for (EntityRelationship rel : patient.getEntityRelationships()) {
            if (!rel.isActive() || rel.getActiveEndTime() != null) continue;
            String shortname = rel.getArchetype();
            EntityRelationship currentActive = (EntityRelationship)currentActives.get(shortname);
            currentActive = rel.isNew() ? PatientRelationshipRules.checkNewRelationship(rel, currentActive) : PatientRelationshipRules.checkExistingRelationship(rel, currentActive);
            currentActives.put(shortname, currentActive);
        }
    }

    public static IArchetypeQuery createPatientRelationshipQuery(Party customer, String[] relationshipShortNames) {
        NamedQuery query = new NamedQuery("getPatientRelationships", new String[]{"relationship.id", "patient.id", "patient.name", "patient.description", "patient.active", "patient.deceased"});
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("shortNames", (Object)relationshipShortNames);
        return query;
    }

    private static EntityRelationship checkNewRelationship(EntityRelationship relationship, EntityRelationship currentActive) {
        if (currentActive == null) {
            currentActive = relationship;
        } else if (currentActive.isNew()) {
            if (PatientRelationshipRules.after(relationship, currentActive)) {
                PatientRelationshipRules.deactivate(currentActive);
                currentActive = relationship;
            } else {
                PatientRelationshipRules.deactivate(relationship);
            }
        } else {
            PatientRelationshipRules.deactivate(currentActive);
            currentActive = relationship;
        }
        return currentActive;
    }

    private static EntityRelationship checkExistingRelationship(EntityRelationship relationship, EntityRelationship currentActive) {
        if (currentActive == null) {
            currentActive = relationship;
        } else if (currentActive.isNew()) {
            PatientRelationshipRules.deactivate(relationship);
        } else if (PatientRelationshipRules.after(relationship, currentActive)) {
            PatientRelationshipRules.deactivate(currentActive);
            currentActive = relationship;
        } else if (PatientRelationshipRules.after(currentActive, relationship)) {
            PatientRelationshipRules.deactivate(relationship);
        }
        return currentActive;
    }

    private static void deactivate(EntityRelationship relationship) {
        Date end = new Date(System.currentTimeMillis() - 1000L);
        relationship.setActiveEndTime(end);
    }

    private static boolean after(EntityRelationship r1, EntityRelationship r2) {
        return r1.getActiveStartTime().after(r2.getActiveStartTime());
    }
}

