/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.openvpms.archetype.rules.patient.ClinicalEventHelper;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.CollectionNodeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;

public class MedicalRecordRules {
    private final IArchetypeService service;
    private String[] clinicalEventItems;
    private String[] clinicalProblemItems;
    private String[] lockableRecords;
    private static final String START_TIME = "startTime";
    private static final String PATIENT = "patient";
    private static final String CLINICIAN = "clinician";
    private static final String ITEMS = "items";
    private static final String TARGET = "target";

    public MedicalRecordRules(IArchetypeService service) {
        this.service = service;
    }

    public Act createNote(Date startTime, Party patient, String note, User clinician) {
        Act act = (Act)this.service.create("act.patientClinicalNote", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setValue(START_TIME, (Object)startTime);
        bean.setTarget(PATIENT, (IMObject)patient);
        bean.setValue("note", (Object)note);
        if (clinician != null) {
            bean.setTarget(CLINICIAN, (IMObject)clinician);
        }
        return act;
    }

    public void addToEvent(Act act, Date startTime) {
        this.addToEvents(Collections.singletonList(act), startTime);
    }

    public void linkMedicalRecords(Act parent, Act child) {
        if (TypeHelper.isA((IMObject)child, (String)"act.patientClinicalProblem")) {
            this.linkMedicalRecords(parent, child, null, null);
        } else if (!TypeHelper.isA((IMObject)child, (String)"act.patientClinicalAddendum")) {
            this.linkMedicalRecords(parent, null, child, null);
        } else {
            this.linkMedicalRecords(parent, null, null, child);
        }
    }

    public void linkMedicalRecords(Act event, Act problem, Act item, Act addendum) {
        if (event != null && !event.isA("act.patientClinicalEvent")) {
            throw new IllegalArgumentException("Argument 'event' is of the wrong type: " + event.getArchetype());
        }
        if (TypeHelper.isA((IMObject)item, (String)"act.patientClinicalProblem")) {
            throw new IllegalArgumentException("Argument 'item' is of the wrong type: " + item.getArchetype());
        }
        if (problem != null && !problem.isA("act.patientClinicalProblem")) {
            throw new IllegalArgumentException("Argument 'problem' is of the wrong type: " + problem.getArchetype());
        }
        if (addendum != null && !addendum.isA("act.patientClinicalAddendum")) {
            throw new IllegalArgumentException("Argument 'addendum' is of the wrong type: " + addendum.getArchetype());
        }
        HashSet<Act> changed = new HashSet<Act>();
        if (item != null && addendum != null) {
            this.linkAddendumToItem(item, addendum, changed);
        }
        if (problem != null) {
            this.linkToProblem(problem, item, addendum, changed);
        }
        if (event != null) {
            this.linkToEvent(event, item, addendum, changed);
        }
        if (!changed.isEmpty()) {
            this.service.save(changed);
        }
        if (problem != null) {
            this.linkProblemToEvent(event, problem);
        }
    }

    public void addToEvents(List<Act> acts, Date startTime) {
        PatientHistoryChanges changes = new PatientHistoryChanges(null, (ArchetypeService)this.service);
        changes.addToEvents(acts, startTime);
        changes.save();
    }

    public Act getEventForAddition(Party patient, Date startTime, Entity clinician) {
        Reference clinicianRef = clinician != null ? clinician.getObjectReference() : null;
        return this.getEventForAddition(patient.getObjectReference(), startTime, clinicianRef);
    }

    public Act getEventForAddition(Reference patient, Date startTime, Reference clinician) {
        PatientHistoryChanges events = new PatientHistoryChanges(null, (ArchetypeService)this.service);
        return events.getEventForAddition(patient, startTime, clinician);
    }

    public Act createEvent(Party patient, Date startTime, Entity clinician) {
        Reference clinicianRef = clinician != null ? clinician.getObjectReference() : null;
        return ClinicalEventHelper.createEvent(patient.getObjectReference(), startTime, clinicianRef, (ArchetypeService)this.service);
    }

    public void addToHistoricalEvents(List<Act> acts, Date date) {
        Map<Reference, List<Act>> map = PatientHistoryChanges.getByPatient(acts, (ArchetypeService)this.service);
        for (Map.Entry<Reference, List<Act>> entry : map.entrySet()) {
            Reference patient = entry.getKey();
            Act event = this.getEvent(patient, date);
            if (event == null) {
                event = ClinicalEventHelper.createEvent(patient, date, null, (ArchetypeService)this.service);
                event.setStatus("COMPLETED");
            }
            boolean save = false;
            IMObjectBean bean = this.service.getBean((IMObject)event);
            for (Act a : entry.getValue()) {
                if (bean.getValue(ITEMS, Relationship.class, Predicates.targetEquals((IMObject)a)) != null) continue;
                ActRelationship relationship = (ActRelationship)bean.addTarget(ITEMS, (IMObject)a);
                a.addActRelationship(relationship);
                save = true;
            }
            if (!save) continue;
            bean.save();
        }
    }

    public Act getEvent(Party patient) {
        return this.getEvent(patient.getObjectReference());
    }

    public Act getEvent(Reference patient) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientClinicalEvent", true, true);
        query.add((IConstraint)new CollectionNodeConstraint(PATIENT).add((IConstraint)new ObjectRefNodeConstraint("entity", patient)));
        query.add((IConstraint)new NodeSortConstraint(START_TIME, false));
        query.add((IConstraint)new NodeSortConstraint("id", false));
        query.setMaxResults(1);
        IMObjectQueryIterator iter = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iter.hasNext() ? (Act)iter.next() : null;
    }

    public Act getEvent(Party patient, Date date) {
        return this.getEvent(patient.getObjectReference(), date);
    }

    public Act getEvent(Reference patient, Date date) {
        return ClinicalEventHelper.getEvent(patient, date, (ArchetypeService)this.service);
    }

    public boolean needsLock(Act act, Period period) {
        return this.needsLock(act, new DateTime().minus((ReadablePeriod)period).toDate());
    }

    public boolean needsLock(Act act, Date lockTime) {
        return !"POSTED".equals(act.getStatus()) && TypeHelper.isA((IMObject)act, (String[])this.getLockableRecords()) && DateRules.compareTo(act.getActivityStartTime(), lockTime) <= 0;
    }

    public synchronized String[] getLockableRecords() {
        if (this.lockableRecords == null) {
            ArrayList<String> items = new ArrayList<String>(Arrays.asList(this.getClinicalEventItems()));
            items.remove("act.patientClinicalProblem");
            HashSet<String> versionTargets = new HashSet<String>();
            for (String item : items) {
                NodeDescriptor versions = DescriptorHelper.getNode((String)item, (String)"versions", (ArchetypeService)this.service);
                if (versions == null) continue;
                for (String relationship : DescriptorHelper.getShortNames((NodeDescriptor)versions, (ArchetypeService)this.service)) {
                    String[] targets = DescriptorHelper.getNodeShortNames((String)relationship, (String)TARGET, (ArchetypeService)this.service);
                    versionTargets.addAll(Arrays.asList(targets));
                }
            }
            items.addAll(versionTargets);
            this.lockableRecords = items.toArray(new String[0]);
        }
        return this.lockableRecords;
    }

    public DocumentAct getAttachment(String fileName, Act event) {
        ArchetypeQuery query = this.createAttachmentQuery(fileName, event);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (DocumentAct)iterator.next() : null;
    }

    public DocumentAct getAttachment(String fileName, Act event, String identityArchetype, String identity) {
        ArchetypeQuery query = this.createAttachmentQuery(fileName, event);
        query.add((IConstraint)Constraints.join((String)"identities", (BaseArchetypeConstraint)Constraints.shortName((String)identityArchetype)).add((IConstraint)Constraints.eq((String)"identity", (Object)identity)));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (DocumentAct)iterator.next() : null;
    }

    private void linkToEvent(Act event, Act item, Act addendum, Set<Act> changed) {
        IMObjectBean bean = this.service.getBean((IMObject)event);
        if (item != null && (item.isA("act.customerAccountInvoiceItem") || item.isA(this.getClinicalEventItems()))) {
            this.linkItemToEvent(bean, item, changed);
        }
        if (addendum != null) {
            this.linkItemToEvent(bean, addendum, changed);
        }
    }

    private void linkToProblem(Act problem, Act item, Act addendum, Set<Act> changed) {
        IMObjectBean bean = this.service.getBean((IMObject)problem);
        if (item != null && TypeHelper.isA((IMObject)item, (String[])this.getClinicalProblemItems())) {
            this.linkItemToProblem(bean, item, changed);
        }
        if (addendum != null) {
            this.linkItemToProblem(bean, addendum, changed);
        }
    }

    private synchronized String[] getClinicalEventItems() {
        if (this.clinicalEventItems == null) {
            this.clinicalEventItems = DescriptorHelper.getNodeShortNames((String)"actRelationship.patientClinicalEventItem", (String)TARGET, (ArchetypeService)this.service);
        }
        return this.clinicalEventItems;
    }

    private synchronized String[] getClinicalProblemItems() {
        if (this.clinicalProblemItems == null) {
            this.clinicalProblemItems = DescriptorHelper.getNodeShortNames((String)"actRelationship.patientClinicalProblemItem", (String)TARGET, (ArchetypeService)this.service);
        }
        return this.clinicalProblemItems;
    }

    private void linkItemToProblem(IMObjectBean bean, Act item, Set<Act> changed) {
        if (this.addRelationship(bean, ITEMS, item)) {
            changed.add((Act)bean.getObject(Act.class));
            changed.add(item);
        }
    }

    private void linkItemToEvent(IMObjectBean bean, Act item, Set<Act> changed) {
        Act event = (Act)bean.getObject(Act.class);
        if (TypeHelper.isA((IMObject)item, (String)"act.customerAccountInvoiceItem")) {
            if (this.addRelationship(bean, "chargeItems", item)) {
                changed.add(event);
                changed.add(item);
            }
        } else if (this.addRelationship(bean, ITEMS, item)) {
            changed.add(event);
            changed.add(item);
        }
    }

    private boolean addRelationship(IMObjectBean bean, String node, Act target) {
        boolean result = false;
        if (bean.getValue(node, ActRelationship.class, Predicates.targetEquals((IMObject)target)) == null) {
            ActRelationship relationship = (ActRelationship)bean.addTarget(node, (IMObject)target);
            target.addActRelationship(relationship);
            result = true;
        }
        return result;
    }

    private void linkProblemToEvent(Act event, Act problem) {
        List acts;
        IMObjectBean problemBean = this.service.getBean((IMObject)problem);
        ArrayList<Act> toSave = new ArrayList<Act>();
        IMObjectBean bean = this.service.getBean((IMObject)event);
        if (this.addRelationship(bean, ITEMS, problem)) {
            toSave.add(event);
        }
        if (!(acts = problemBean.getTargets(ITEMS, Act.class)).isEmpty()) {
            String[] shortNames = this.getClinicalEventItems();
            for (Act child : acts) {
                IMObjectBean childBean = this.service.getBean((IMObject)child);
                if (!childBean.isA(shortNames) || !this.addRelationship(bean, ITEMS, child)) continue;
                toSave.add(child);
            }
        }
        if (!toSave.isEmpty()) {
            this.service.save(toSave);
        }
    }

    private void linkAddendumToItem(Act item, Act addendum, Set<Act> changed) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        if (!this.addRelationship(bean, "addenda", addendum)) {
            changed.add(item);
            changed.add(addendum);
        }
    }

    private ArchetypeQuery createAttachmentQuery(String fileName, Act event) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientDocumentAttachment");
        query.add((IConstraint)Constraints.join((String)"event").add((IConstraint)Constraints.eq((String)"source", (Object)event)));
        query.add((IConstraint)Constraints.eq((String)"fileName", (Object)fileName));
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)false));
        query.add((IConstraint)Constraints.sort((String)"id", (boolean)false));
        query.setMaxResults(1);
        return query;
    }
}

