/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Date;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

class ClinicalEventHelper {
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";

    ClinicalEventHelper() {
    }

    public static Act getEvent(Reference patient, Date date, ArchetypeService service) {
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root from = query.from(Act.class, new String[]{"act.patientClinicalEvent"});
        Join join = from.join("patient").join("entity");
        join.on((Expression)builder.equal((Expression)join.reference(), (Object)patient));
        Date lowerBound = DateRules.getDate(date);
        Date upperBound = DateRules.getNextDate(lowerBound);
        query.where(new Predicate[]{builder.lessThan((Expression)from.get(START_TIME), (Comparable)upperBound), builder.or((Expression)builder.greaterThanOrEqualTo((Expression)from.get(END_TIME), (Comparable)lowerBound), (Expression)from.get(END_TIME).isNull())});
        query.orderBy(new Order[]{builder.asc((Expression)from.get(START_TIME)), builder.asc((Expression)from.get("id"))});
        List acts = service.createQuery(query).getResultList();
        Act result = null;
        long resultDistance = 0L;
        for (Act event : acts) {
            if (result == null) {
                resultDistance = ClinicalEventHelper.distance(date, event);
                result = event;
                continue;
            }
            long distance = ClinicalEventHelper.distance(date, event);
            if (distance >= resultDistance) continue;
            resultDistance = distance;
            result = event;
        }
        return result;
    }

    public static Act createEvent(Reference patient, Date startTime, Reference clinician, ArchetypeService service) {
        Act event = (Act)service.create("act.patientClinicalEvent", Act.class);
        event.setActivityStartTime(startTime);
        IMObjectBean eventBean = service.getBean((IMObject)event);
        eventBean.setTarget("patient", patient);
        if (clinician != null) {
            eventBean.setTarget("clinician", clinician);
        }
        return event;
    }

    public static long distance(Date date, Act event) {
        long dateSecs = ClinicalEventHelper.getSeconds(date);
        long startTime = ClinicalEventHelper.getSeconds(event.getActivityStartTime());
        long endTime = event.getActivityEndTime() != null ? ClinicalEventHelper.getSeconds(event.getActivityEndTime()) : 0L;
        long distStartTime = Math.abs(startTime - dateSecs);
        if (endTime != 0L) {
            return distStartTime;
        }
        long distEndTime = Math.abs(endTime - dateSecs);
        return Math.min(distStartTime, distEndTime);
    }

    private static long getSeconds(Date date) {
        return date.getTime() / 1000L;
    }
}

