/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class Contacts {
    public static final String EMAIL_ADDRESS = "emailAddress";
    public static final String TELEPHONE_NUMBER = "telephoneNumber";
    private final ArchetypeService service;

    public Contacts(ArchetypeService service) {
        this.service = service;
    }

    public List<Contact> getEmailContacts(Party party) {
        return Contacts.getContacts(party, new EmailPredicate());
    }

    public Contact getEmailContact(Party party) {
        List<Contact> list = this.sortPreferred(this.getEmailContacts(party));
        return !list.isEmpty() ? list.get(0) : null;
    }

    public String getEmail(Party party) {
        String result = null;
        Contact contact = this.getEmailContact(party);
        if (contact != null) {
            IMObjectBean bean = this.service.getBean((IMObject)contact);
            result = StringUtils.trimToNull((String)bean.getString(EMAIL_ADDRESS));
        }
        return result;
    }

    public List<Contact> getSMSContacts(Party party) {
        return Contacts.getContacts(party, new SMSPredicate());
    }

    public boolean canSMS(Party party) {
        return IterableUtils.find((Iterable)party.getContacts(), (Predicate)new SMSPredicate()) != null;
    }

    public String getPhone(Contact contact) {
        IMObjectBean bean = this.service.getBean((IMObject)contact);
        String areaCode = bean.getString("areaCode");
        String phone = bean.getString(TELEPHONE_NUMBER);
        return Contacts.getPhone(areaCode, phone);
    }

    public static <T extends Contact> List<T> sort(List<T> contacts) {
        if (contacts.size() > 1) {
            contacts.sort(Comparator.comparingLong(IMObject::getId));
        }
        return contacts;
    }

    public static <T extends Contact> List<T> sort(Collection<T> contacts) {
        return Contacts.sort(new ArrayList<T>(contacts));
    }

    public static Contact find(Collection<Contact> contacts, ContactMatcher matcher) {
        for (Contact contact : contacts) {
            if (matcher.matches(contact)) break;
        }
        return matcher.getMatch();
    }

    public static String getPhone(String areaCode, String phoneNumber) {
        String result = null;
        areaCode = StringUtils.trimToNull((String)areaCode);
        phoneNumber = StringUtils.trimToNull((String)phoneNumber);
        if (areaCode != null && phoneNumber != null) {
            result = areaCode;
            result = result + phoneNumber;
        } else if (phoneNumber != null) {
            result = phoneNumber;
        }
        return Contacts.getPhone(result);
    }

    public static String getPhone(String phone) {
        String result = phone;
        if (!StringUtils.isEmpty((CharSequence)result)) {
            result = result.replaceAll("[\\s\\-()]", "").replaceAll("[^\\d+].*", "");
        }
        return result;
    }

    public static List<Contact> getContacts(Party party, Predicate<Contact> predicate) {
        ArrayList<Contact> result = new ArrayList<Contact>();
        CollectionUtils.select((Iterable)party.getContacts(), predicate, result);
        return result;
    }

    private List<Contact> sortPreferred(List<Contact> list) {
        if (list.size() > 1) {
            list.sort((o1, o2) -> {
                boolean preferred2;
                boolean preferred1 = this.isPreferred((Contact)o1);
                int result = preferred1 == (preferred2 = this.isPreferred((Contact)o1)) ? Long.compare(o1.getId(), o2.getId()) : (preferred1 ? -1 : 1);
                return result;
            });
        }
        return list;
    }

    private boolean isPreferred(Contact contact) {
        IMObjectBean bean = this.service.getBean((IMObject)contact);
        return bean.hasNode("preferred") && bean.getBoolean("preferred");
    }

    private class EmailPredicate
    implements Predicate<Contact> {
        private EmailPredicate() {
        }

        public boolean evaluate(Contact contact) {
            IMObjectBean bean;
            boolean result = false;
            if (TypeHelper.isA((IMObject)contact, (String)"contact.email") && !StringUtils.isEmpty((CharSequence)(bean = Contacts.this.service.getBean((IMObject)contact)).getString(Contacts.EMAIL_ADDRESS))) {
                result = true;
            }
            return result;
        }
    }

    private class SMSPredicate
    implements Predicate<Contact> {
        private SMSPredicate() {
        }

        public boolean evaluate(Contact contact) {
            String phone;
            IMObjectBean bean;
            boolean result = false;
            if (TypeHelper.isA((IMObject)contact, (String)"contact.phoneNumber") && (bean = Contacts.this.service.getBean((IMObject)contact)).getBoolean("sms") && !StringUtils.isEmpty((CharSequence)(phone = bean.getString(Contacts.TELEPHONE_NUMBER)))) {
                result = true;
            }
            return result;
        }
    }
}

