/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.message;

import java.util.Date;
import org.openvpms.archetype.rules.message.MessageArchetypes;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;

public class MessageRules {
    private final IArchetypeService service;
    private final String[] ARCHETYPES = MessageArchetypes.MESSAGES.toArray(new String[0]);

    public MessageRules(IArchetypeService service) {
        this.service = service;
    }

    public boolean hasNewMessages(User user) {
        return this.hasNewMessages(user, null);
    }

    public boolean hasNewMessages(User user, Date date) {
        String[] archetypes = DescriptorHelper.getShortNames((String[])this.ARCHETYPES, (boolean)true, (ArchetypeService)this.service);
        ArchetypeQuery query = new ArchetypeQuery(archetypes, true, false);
        query.add((IConstraint)new NodeSelectConstraint("id"));
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"PENDING"));
        JoinConstraint to = Constraints.join((String)"to");
        to.add((IConstraint)Constraints.eq((String)"entity", (Reference)user.getObjectReference()));
        if (archetypes.length > 1) {
            OrConstraint or = new OrConstraint();
            for (String archetype : archetypes) {
                or.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)archetype));
            }
            to.add((IConstraint)or);
        } else if (archetypes.length == 1) {
            to.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)archetypes[0]));
        }
        if (date != null) {
            to.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.GTE, (Object)date));
        }
        query.add((IConstraint)to);
        if (date != null) {
            query.add((IConstraint)Constraints.gte((String)"startTime", (Object)date));
        }
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext();
    }
}

