/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

public class MathRules {
    public static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
    public static final BigDecimal ONE_THOUSAND = BigDecimal.valueOf(1000L);
    public static final BigDecimal ONE_POUND_IN_KILOS = new BigDecimal("0.45359237");
    public static final BigDecimal ONE_POUND_IN_GRAMS = ONE_POUND_IN_KILOS.multiply(ONE_THOUSAND);
    public static final BigDecimal ONE_KILO_IN_POUNDS = BigDecimal.ONE.divide(ONE_POUND_IN_KILOS, 8, 4);
    public static final BigDecimal ONE_GRAM_IN_POUNDS = BigDecimal.ONE.divide(ONE_POUND_IN_GRAMS, 8, 4);

    private MathRules() {
    }

    public static BigDecimal calculateTotal(BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal quantity, BigDecimal discount, int scale) {
        BigDecimal total;
        if (!MathRules.isZero(quantity)) {
            BigDecimal unitTotal = MathRules.round(quantity.abs().multiply(unitPrice), scale);
            total = fixedPrice.add(unitTotal).subtract(discount);
            if (quantity.signum() < 0) {
                total = total.negate();
            }
            total = MathRules.round(total, scale);
        } else {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    public static BigDecimal round(BigDecimal value) {
        return MathRules.round(value, 2);
    }

    public static BigDecimal round(BigDecimal value, int scale) {
        return value.setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal dividend, BigDecimal divisor, int scale) {
        return dividend.divide(divisor, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal dividend, int divisor, int scale) {
        return MathRules.divide(dividend, BigDecimal.valueOf(divisor), scale);
    }

    public static boolean equals(BigDecimal lhs, BigDecimal rhs) {
        if (lhs != null && rhs != null) {
            return lhs.compareTo(rhs) == 0;
        }
        return Objects.equals(lhs, rhs);
    }

    public static boolean isZero(BigDecimal value) {
        return value.signum() == 0;
    }

    public static boolean isPositive(BigDecimal value) {
        return value.signum() > 0;
    }

    public static boolean intersects(BigDecimal from1, BigDecimal to1, BigDecimal from2, BigDecimal to2) {
        if (from1 == null && to1 == null) {
            return true;
        }
        if (from1 == null) {
            return from2 == null || to1.compareTo(from2) > 0;
        }
        if (to1 == null) {
            return to2 == null || from1.compareTo(to2) < 0;
        }
        if (from2 == null && to2 == null) {
            return true;
        }
        if (from2 == null) {
            return from1.compareTo(to2) < 0;
        }
        if (to2 == null) {
            return to1.compareTo(from2) > 0;
        }
        return from2.compareTo(to1) < 0 && to2.compareTo(from1) > 0;
    }
}

