/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.openvpms.archetype.rules.finance.till.TillHelper;
import org.openvpms.archetype.rules.finance.till.TillRuleException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;

public class TillBalanceRules {
    private final IArchetypeService service;

    public TillBalanceRules(IArchetypeService service) {
        this.service = service;
    }

    public FinancialAct getUnclearedBalance(Entity till) {
        return TillHelper.getUnclearedTillBalance(till, this.service);
    }

    public void checkCanSaveTillBalance(Act act) {
        Entity till;
        FinancialAct current;
        if (!act.isA("act.tillBalance")) {
            throw new TillRuleException(TillRuleException.ErrorCode.InvalidTillArchetype, act.getArchetype());
        }
        Act oldAct = (Act)this.service.get(act.getObjectReference(), Act.class);
        if (oldAct != null) {
            if ("CLEARED".equals(oldAct.getStatus())) {
                throw new TillRuleException(TillRuleException.ErrorCode.ClearedTill, act.getId());
            }
        } else if ("UNCLEARED".equals(act.getStatus()) && (current = TillHelper.getUnclearedTillBalance(till = TillHelper.getTill(act, this.service), this.service)) != null && current.getId() != act.getId()) {
            throw new TillRuleException(TillRuleException.ErrorCode.UnclearedTillExists, till.getName());
        }
    }

    public void addToTill(Act act) {
        List<Act> acts = this.addToBalance(act);
        if (!acts.isEmpty()) {
            this.service.save(acts);
        }
    }

    public List<Act> addToBalance(Act act) {
        List<Act> result;
        if (this.checkAdd(act)) {
            FinancialAct balance = this.getBalance(act);
            result = this.doAddToBalance(act, (Act)balance);
        } else {
            result = act.isA("act.tillBalanceAdjustment") ? this.updateBalanceForTillAdjustment(act) : Collections.emptyList();
        }
        return result;
    }

    public List<Act> addToBalance(Act act, Act balance) {
        List<Object> result = this.checkAdd(act) ? this.doAddToBalance(act, balance) : (act.isA("act.tillBalanceAdjustment") ? this.updateBalanceForTillAdjustment(act) : Collections.emptyList());
        return result;
    }

    public boolean updateBalance(FinancialAct balance) {
        boolean result = false;
        if ("CLEARED".equals(balance.getStatus())) {
            throw new TillRuleException(TillRuleException.ErrorCode.ClearedTill, balance.getId());
        }
        IMObjectBean bean = this.service.getBean((IMObject)balance);
        if (TillHelper.updateBalance(bean, this.service)) {
            this.service.save((IMObject)balance);
            result = true;
        }
        return result;
    }

    private List<Act> doAddToBalance(Act act, Act balance) {
        ArrayList<Act> result = new ArrayList<Act>();
        if ("CLEARED".equals(balance.getStatus())) {
            throw new IllegalStateException("Till balance cannot be CLEARED");
        }
        IMObjectBean bean = this.service.getBean((IMObject)act);
        IMObjectBean balanceBean = this.service.getBean((IMObject)balance);
        Reference till = bean.getTargetRef("till");
        if (till == null) {
            throw new IllegalStateException(act.getObjectReference() + "  has no till");
        }
        if (!Objects.equals(till, balanceBean.getTargetRef("till"))) {
            throw new IllegalStateException(act.getObjectReference() + "  has as different till to " + balance.getObjectReference());
        }
        if (!balanceBean.hasTarget("items", (IMObject)act)) {
            ActRelationship relationship = (ActRelationship)balanceBean.addTarget("items", (IMObject)act);
            act.addActRelationship(relationship);
            result.add(act);
            result.add(balance);
            TillHelper.updateBalance(balanceBean, this.service);
        }
        return result;
    }

    private boolean checkAdd(Act act) {
        boolean add = true;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        boolean isAccount = bean.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"});
        boolean isAdjust = bean.isA(new String[]{"act.tillBalanceAdjustment"});
        if (!isAccount && !isAdjust) {
            throw new TillRuleException(TillRuleException.ErrorCode.CantAddActToTill, act.getArchetype());
        }
        if (isAccount && !"POSTED".equals(act.getStatus())) {
            add = false;
        } else if (act.getActRelationships().stream().anyMatch(Predicates.isA((String[])new String[]{"actRelationship.tillBalanceItem"}))) {
            add = false;
        }
        return add;
    }

    private FinancialAct getBalance(Act act) {
        Reference tillRef = TillHelper.getTillRef(act, this.service);
        FinancialAct balance = TillHelper.getUnclearedTillBalance(tillRef, this.service);
        if (balance == null) {
            Entity till = (Entity)this.service.get(tillRef);
            if (till == null) {
                throw new TillRuleException(TillRuleException.ErrorCode.TillNotFound, tillRef.getId());
            }
            balance = TillHelper.createTillBalance(till, this.service);
        }
        return balance;
    }

    private List<Act> updateBalanceForTillAdjustment(Act act) {
        List<Act> result = Collections.emptyList();
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Policy policy = Policies.any(ActRelationship.class, (Predicate)Predicates.isA((String[])new String[]{"actRelationship.tillBalanceItem"}));
        FinancialAct balance = (FinancialAct)bean.getSource((Collection)act.getActRelationships(), FinancialAct.class, policy);
        if (balance != null && this.updateBalance(balance)) {
            result = new ArrayList<Act>();
            result.add((Act)balance);
        }
        return result;
    }
}

