/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.StatementActHelper;
import org.openvpms.archetype.rules.finance.statement.StatementPeriod;
import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.IterableIMObjectQuery;
import org.openvpms.component.system.common.util.IterableChain;

public class StatementRules {
    private final IArchetypeService service;
    private final CustomerAccountRules account;
    private final StatementActHelper acts;
    private final CustomerTaxRules tax;
    private static final String START_TIME = "startTime";
    private static final String TYPE = "type";

    public StatementRules(Party practice, IArchetypeService service, CustomerAccountRules rules) {
        this.service = service;
        this.account = rules;
        this.acts = new StatementActHelper(service);
        this.tax = new CustomerTaxRules(practice, service);
    }

    public boolean hasStatement(Party customer, Date date) {
        return this.acts.hasStatement(customer, date);
    }

    public Iterable<FinancialAct> getStatementPreview(Party customer, Date date, boolean includeCompletedCharges, boolean includeFee) {
        FinancialAct opening = this.getLastOpeningBalance(customer);
        return this.getStatementPreview(customer, opening != null ? opening.getActivityStartTime() : null, date, includeCompletedCharges, includeFee);
    }

    public Iterable<FinancialAct> getStatementPreview(Party customer, Date from, Date to, boolean includeCompletedCharges, boolean includeFee) {
        BigDecimal fee;
        Date statementTime = this.acts.getStatementTimestamp(to);
        Object result = includeCompletedCharges ? this.acts.getPostedAndCompletedActs(customer, statementTime, from) : this.acts.getPostedActs(customer, from, statementTime, false);
        if (includeFee && (fee = this.getAccountFee(customer, to)).compareTo(BigDecimal.ZERO) != 0) {
            Date date = StatementPeriod.getFeeTimestamp(statementTime);
            FinancialAct feeAct = this.createAccountingFeeAdjustment(customer, fee, date);
            result = new IterableChain(result, (Object)feeAct);
        }
        return result;
    }

    public Iterable<FinancialAct> getStatement(Party customer, Date date) {
        FinancialAct opening = this.account.getOpeningBalanceBefore(customer, date);
        return this.getStatement(customer, opening != null ? opening.getActivityStartTime() : null, date);
    }

    public Iterable<FinancialAct> getStatement(Party customer, Date from, Date to) {
        Date statementTime = this.acts.getStatementTimestamp(to);
        Date closingBalanceTimestamp = StatementPeriod.getClosingBalanceTimestamp(statementTime);
        return this.acts.getPostedActs(customer, from, closingBalanceTimestamp, false);
    }

    public Iterable<FinancialAct> getStatementRange(Party customer, Date from, Date to) {
        FinancialAct openingBalance = null;
        if (from != null) {
            BigDecimal balance;
            FinancialAct before = this.account.getOpeningBalanceBefore(customer, from);
            if (before != null) {
                BigDecimal opening = before.getTotal();
                if (before.isCredit()) {
                    opening = opening.negate();
                }
                balance = this.account.getBalance(customer, before.getActivityStartTime(), from, false, opening);
            } else {
                balance = this.account.getBalance(customer, null, from, false, BigDecimal.ZERO);
            }
            openingBalance = this.account.createOpeningBalance(customer, from, balance);
        }
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, CustomerAccountArchetypes.DEBITS_CREDITS);
        if (from != null) {
            query.add((IConstraint)Constraints.gte((String)START_TIME, (Object)from));
        }
        if (to != null) {
            query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)to));
        }
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        query.add((IConstraint)Constraints.sort((String)"id"));
        IterableIMObjectQuery iterator = new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
        return openingBalance != null ? new IterableChain((Object)openingBalance, (Iterable)iterator) : iterator;
    }

    public void setPrinted(Party customer, Date statementDate) {
        FinancialAct act = this.getClosingBalance(customer, statementDate);
        if (act != null) {
            act.setPrinted(true);
            this.service.save((IMObject)act);
        }
    }

    public FinancialAct getClosingBalance(Party customer, Date statementDate) {
        return this.acts.getClosingBalance(customer, statementDate);
    }

    public BigDecimal getAccountFee(Party customer, Date statementDate) {
        BigDecimal result = BigDecimal.ZERO;
        AccountType accountType = this.getAccountType(customer);
        if (accountType != null) {
            BigDecimal fee;
            statementDate = this.acts.getStatementTimestamp(statementDate);
            Date feeDate = accountType.getAccountFeeDate(statementDate);
            feeDate = this.acts.getStatementTimestamp(feeDate);
            BigDecimal overdue = this.account.getOverdueBalance(customer, statementDate, feeDate);
            BigDecimal feeBalance = accountType.getAccountFeeBalance();
            if (overdue.compareTo(BigDecimal.ZERO) != 0 && overdue.compareTo(feeBalance) >= 0 && (fee = accountType.getAccountFee(overdue)).compareTo(accountType.getAccountFeeMinimum()) >= 0) {
                result = fee;
            }
        }
        return result;
    }

    public FinancialAct createAccountingFeeAdjustment(Party customer, BigDecimal fee, Date startTime) {
        FinancialAct act = (FinancialAct)this.service.create("act.customerAccountDebitAdjust", FinancialAct.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget("customer", (IMObject)customer);
        act.setTotal((BigDecimal)new Money(fee));
        act.setActivityStartTime(startTime);
        act.setStatus("POSTED");
        this.tax.calculateTax(act);
        String notes = "Accounting Fee";
        AccountType accountType = this.getAccountType(customer);
        if (accountType != null && !StringUtils.isEmpty((CharSequence)accountType.getAccountFeeMessage())) {
            notes = accountType.getAccountFeeMessage();
        }
        bean.setValue("notes", (Object)notes);
        return act;
    }

    private FinancialAct getLastOpeningBalance(Party customer) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, "act.customerAccountOpeningBalance");
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)false));
        query.add((IConstraint)Constraints.sort((String)"id", (boolean)false));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (FinancialAct)iterator.next() : null;
    }

    private AccountType getAccountType(Party customer) {
        List accountTypes;
        IMObjectBean bean = this.service.getBean((IMObject)customer);
        if (bean.hasNode(TYPE) && !(accountTypes = bean.getValues(TYPE, Lookup.class)).isEmpty()) {
            return new AccountType((Lookup)accountTypes.get(0), (ArchetypeService)this.service);
        }
        return null;
    }
}

