/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.util.Date;
import java.util.List;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;

public class Statement {
    private final Party customer;
    private final List<Contact> contacts;
    private final Date statementDate;
    private final Iterable<FinancialAct> acts;
    private final Date openingBalanceTimestamp;
    private final Date closingBalanceTimestamp;
    private final boolean printed;

    public Statement(Party customer, List<Contact> contacts, Date statementDate, Date openingBalanceTimestamp, Date closingBalanceTimestamp, Iterable<FinancialAct> acts, boolean printed) {
        this.customer = customer;
        this.contacts = contacts;
        this.statementDate = statementDate;
        this.openingBalanceTimestamp = openingBalanceTimestamp;
        this.closingBalanceTimestamp = closingBalanceTimestamp;
        this.acts = acts;
        this.printed = printed;
    }

    public Party getCustomer() {
        return this.customer;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public Date getStatementDate() {
        return this.statementDate;
    }

    public Date getOpeningBalanceTimestamp() {
        return this.openingBalanceTimestamp;
    }

    public Date getClosingBalanceTimestamp() {
        return this.closingBalanceTimestamp;
    }

    public boolean isPreview() {
        return this.closingBalanceTimestamp == null;
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public Iterable<FinancialAct> getActs() {
        return this.acts;
    }
}

