/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.payment;

import java.util.function.Predicate;
import org.openvpms.archetype.rules.act.ActStatusHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class PaymentRules {
    private final ArchetypeService service;

    public PaymentRules(IArchetypeService service) {
        this.service = service;
    }

    public void removePaymentRefund(FinancialAct act) {
        if (!act.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
            throw new IllegalArgumentException("Invalid argument 'act'");
        }
        if (ActStatusHelper.isPosted((Act)act, this.service)) {
            throw new IllegalStateException("Act is POSTED");
        }
        IMObjectBean bean = this.service.getBean((IMObject)act);
        for (FinancialAct item : bean.getTargets("items", FinancialAct.class, Policies.any((Predicate)Predicates.targetIsA((String[])new String[]{"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT"})))) {
            this.removeEFTItem(item);
        }
    }

    public void removeEFTItem(FinancialAct item) {
        if (!item.isA(new String[]{"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT"})) {
            throw new IllegalArgumentException("Invalid argument 'act'");
        }
        IMObjectBean bean = this.service.getBean((IMObject)item);
        for (Act act : bean.getTargets("eft", Act.class)) {
            if (!act.getStatus().equals("NO_TERMINAL")) continue;
            bean.removeTargets("eft", (IMObject)act, "transaction");
            this.service.save((IMObject)item);
            this.service.remove((IMObject)act);
        }
    }
}

