/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class OrderRules {
    private final IArchetypeService service;
    private static final String SOURCE_INVOICE_ITEM = "sourceInvoiceItem";

    public OrderRules(IArchetypeService service) {
        this.service = service;
    }

    public boolean hasOrders(Party customer) {
        ArchetypeQuery query = this.createQuery(customer);
        return this.hasOrders(query);
    }

    public boolean hasOrders(Party customer, Party patient) {
        ArchetypeQuery query = this.createQuery(customer, patient);
        return this.hasOrders(query);
    }

    public List<Act> getOrders(Party customer) {
        ArchetypeQuery query = this.createQuery(customer);
        return this.collect(query);
    }

    public List<Act> getOrders(Party customer, Party patient) {
        ArchetypeQuery query = this.createQuery(customer, patient);
        if (patient != null) {
            query.setDistinct(true);
        }
        return this.collect(query);
    }

    public Reference getInvoiceItemRef(Act orderItem) {
        IMObjectBean bean = this.service.getBean((IMObject)orderItem);
        return bean.hasNode(SOURCE_INVOICE_ITEM) ? bean.getReference(SOURCE_INVOICE_ITEM) : null;
    }

    public BigDecimal getInvoicedQuantity(Act orderItem) {
        Reference ref;
        BigDecimal result = BigDecimal.ZERO;
        IMObjectBean bean = this.service.getBean((IMObject)orderItem);
        if (bean.hasNode(SOURCE_INVOICE_ITEM) && (ref = bean.getReference(SOURCE_INVOICE_ITEM)) != null) {
            ArchetypeQuery query = new ArchetypeQuery(ref);
            query.getArchetypeConstraint().setAlias("a");
            query.add((IConstraint)new NodeSelectConstraint("quantity"));
            ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
            if (iterator.hasNext()) {
                result = ((ObjectSet)iterator.next()).getBigDecimal("a.quantity");
            }
        }
        return result;
    }

    private boolean hasOrders(ArchetypeQuery query) {
        query.add((IConstraint)new NodeSelectConstraint("id"));
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext();
    }

    private List<Act> collect(ArchetypeQuery query) {
        query.add((IConstraint)Constraints.sort((String)"startTime"));
        query.add((IConstraint)Constraints.sort((String)"id"));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        ArrayList<Act> result = new ArrayList<Act>();
        CollectionUtils.addAll(result, (Iterator)iterator);
        return result;
    }

    private ArchetypeQuery createQuery(Party customer, Party patient) {
        ArchetypeQuery query = this.createQuery(customer);
        if (patient != null) {
            query.add((IConstraint)Constraints.join((String)"items").add((IConstraint)Constraints.join((String)"target").add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.eq((String)"entity", (Object)patient)))));
        }
        return query;
    }

    private ArchetypeQuery createQuery(Party customer) {
        String[] shortNames = new String[]{"act.customerOrder*", "act.customerReturn*"};
        ArchetypeQuery query = new ArchetypeQuery(shortNames, true, true);
        query.add((IConstraint)Constraints.join((String)"customer").add((IConstraint)Constraints.eq((String)"entity", (Object)customer)));
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS"));
        return query;
    }
}

