/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.invoice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ChargeItemDocumentLinker {
    private final FinancialAct item;
    private final IArchetypeService service;
    private static final String PRODUCT = "product";
    private static final String DOCUMENTS = "documents";
    private static final String PATIENT = "patient";
    private static final String CLINICIAN = "clinician";

    public ChargeItemDocumentLinker(FinancialAct item, IArchetypeService service) {
        this.item = item;
        this.service = service;
    }

    public void link() {
        PatientHistoryChanges changes = new PatientHistoryChanges(null, (ArchetypeService)this.service);
        this.prepare(changes);
        changes.save();
    }

    public void prepare(PatientHistoryChanges changes) {
        Map<Object, Object> productTemplates = new HashMap();
        HashSet<Reference> templateRefs = new HashSet<Reference>();
        IMObjectBean itemBean = this.service.getBean((IMObject)this.item);
        Product product = (Product)itemBean.getTarget(PRODUCT, Product.class);
        if (product != null) {
            productTemplates = this.getProductDocumentTemplates(product);
        }
        List documents = itemBean.getTargets(DOCUMENTS, Act.class);
        for (Act document : documents.toArray(new Act[0])) {
            IMObjectBean bean = this.service.getBean((IMObject)document);
            if (this.changed(bean, itemBean, product)) {
                changes.removeItemDocument(this.item, document);
                documents.remove(document);
                continue;
            }
            Reference templateRef = bean.getTargetRef("documentTemplate");
            if (templateRef == null) continue;
            templateRefs.add(templateRef);
        }
        for (Map.Entry entry : productTemplates.entrySet()) {
            Entity entity;
            Reference typeRef = (Reference)entry.getKey();
            if (templateRefs.contains(typeRef) || (entity = (Entity)this.getObject(typeRef)) == null) continue;
            this.addDocument(itemBean, entity, changes);
        }
    }

    Map<Reference, Relationship> getProductDocumentTemplates(Product product) {
        HashMap<Reference, Relationship> result = new HashMap<Reference, Relationship>();
        IMObjectBean productBean = this.service.getBean((IMObject)product);
        if (productBean.hasNode(DOCUMENTS)) {
            for (Relationship r : productBean.getValues(DOCUMENTS, Relationship.class)) {
                Reference target = r.getTarget();
                if (target == null) continue;
                result.put(target, r);
            }
        }
        return result;
    }

    private void addDocument(IMObjectBean itemBean, Entity document, PatientHistoryChanges changes) {
        String type;
        IMObjectBean bean = this.service.getBean((IMObject)document);
        Lookup typeLookup = (Lookup)bean.getObject("type", Lookup.class);
        String string = type = typeLookup != null ? typeLookup.getCode() : "act.patientDocumentForm";
        if (TypeHelper.matches((String)type, (String)"act.patientDocument*")) {
            Act act = (Act)this.service.create(type, Act.class);
            act.setActivityStartTime(((Act)itemBean.getObject()).getActivityStartTime());
            IMObjectBean documentAct = this.service.getBean((IMObject)act);
            Reference patient = itemBean.getTargetRef(PATIENT);
            documentAct.setTarget(PATIENT, patient);
            documentAct.setTarget("documentTemplate", (IMObject)document);
            Reference clinician = itemBean.getTargetRef(CLINICIAN);
            if (clinician != null) {
                documentAct.setTarget(CLINICIAN, clinician);
            }
            if (documentAct.isA(new String[]{"act.patientDocumentForm", "act.patientDocumentLetter"})) {
                Reference product = itemBean.getTargetRef(PRODUCT);
                documentAct.setTarget(PRODUCT, product);
            }
            changes.addItemDocument(this.item, act);
        }
    }

    private boolean productChanged(IMObjectBean bean, Product product) {
        return bean.hasNode(PRODUCT) && !Objects.equals(bean.getTargetRef(PRODUCT), product.getObjectReference());
    }

    private boolean changed(IMObjectBean docBean, IMObjectBean itemBean, Product product) {
        return this.productChanged(docBean, product) || this.patientChanged(docBean, itemBean) || this.clinicianChanged(docBean, itemBean);
    }

    private boolean patientChanged(IMObjectBean docBean, IMObjectBean itemBean) {
        return this.checkParticipant(docBean, itemBean, PATIENT);
    }

    private boolean clinicianChanged(IMObjectBean docBean, IMObjectBean itemBean) {
        return this.checkParticipant(docBean, itemBean, CLINICIAN);
    }

    private boolean checkParticipant(IMObjectBean docBean, IMObjectBean itemBean, String node) {
        return docBean.hasNode(node) && !Objects.equals(docBean.getTargetRef(node), itemBean.getTargetRef(node));
    }

    private IMObject getObject(Reference ref) {
        return ref != null ? this.service.get(ref) : null;
    }
}

