/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.deposit;

import java.util.Date;
import org.openvpms.archetype.rules.finance.deposit.DepositHelper;
import org.openvpms.archetype.rules.finance.deposit.DepositRuleException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;

public class DepositRules {
    private DepositRules() {
    }

    public static void checkCanSaveBankDeposit(FinancialAct act, IArchetypeService service) throws DepositRuleException {
        IMObjectBean bean = service.getBean((IMObject)act);
        if (!bean.isA(new String[]{"act.bankDeposit"})) {
            throw new DepositRuleException(DepositRuleException.ErrorCode.InvalidDepositArchetype, act.getArchetype());
        }
        Act oldAct = (Act)service.get(act.getObjectReference());
        if (oldAct != null) {
            if ("DEPOSITED".equals(oldAct.getStatus())) {
                throw new DepositRuleException(DepositRuleException.ErrorCode.DepositAlreadyDeposited, act.getId());
            }
        } else if ("UNDEPOSITED".equals(act.getStatus())) {
            Entity account = (Entity)bean.getTarget("depositAccount", Entity.class);
            if (account == null) {
                throw new DepositRuleException(DepositRuleException.ErrorCode.MissingAccount, act.getId());
            }
            FinancialAct match = DepositHelper.getUndepositedDeposit(account, service);
            if (match != null && match.getId() != act.getId()) {
                throw new DepositRuleException(DepositRuleException.ErrorCode.UndepositedDepositExists, account.getName());
            }
        }
    }

    public static void deposit(Act act, IArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)act);
        if (!bean.isA(new String[]{"act.bankDeposit"})) {
            throw new DepositRuleException(DepositRuleException.ErrorCode.InvalidDepositArchetype, act.getArchetype());
        }
        if ("DEPOSITED".equals(act.getStatus())) {
            throw new DepositRuleException(DepositRuleException.ErrorCode.DepositAlreadyDeposited, act.getStatus());
        }
        act.setStatus("DEPOSITED");
        IMObject account = bean.getTarget("depositAccount");
        if (account == null) {
            throw new DepositRuleException(DepositRuleException.ErrorCode.MissingAccount, act.getId());
        }
        IMObjectBean accBean = service.getBean(account);
        accBean.setValue("lastDeposit", (Object)new Date());
        bean.save(new IMObject[]{account});
    }
}

