/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.component.business.dao.im.Page;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ObjectSet;

public class DepositQuery {
    public static final String BANK_DEPOSIT = "bankDeposit";
    public static final String TILL_BALANCE = "tillBalance";
    public static final String ACT = "act";
    public static final String ACT_ITEM = "item";
    public static final String AMOUNT = "amount";
    private final FinancialAct bankDeposit;
    private final IArchetypeService service;
    private final ActCalculator calculator;

    public DepositQuery(FinancialAct bankDeposit, IArchetypeService service) {
        this.bankDeposit = bankDeposit;
        this.service = service;
        this.calculator = new ActCalculator((ArchetypeService)service);
    }

    public IPage<ObjectSet> query() {
        ArrayList<ObjectSet> result = new ArrayList<ObjectSet>();
        IMObjectBean bean = this.service.getBean((IMObject)this.bankDeposit);
        for (Act tillBalance : bean.getTargets("items", Act.class)) {
            IMObjectBean tillBalanceBean = this.service.getBean((IMObject)tillBalance);
            for (FinancialAct tillBalanceItem : tillBalanceBean.getTargets("items", FinancialAct.class)) {
                IMObjectBean tillBalanceItemBean = this.service.getBean((IMObject)tillBalanceItem);
                if (tillBalanceItemBean.isA(new String[]{"act.tillBalanceAdjustment"})) {
                    ObjectSet set = this.createCashAdjustmentSet(tillBalanceItem);
                    result.add(set);
                    continue;
                }
                for (Act item : tillBalanceItemBean.getTargets("items", Act.class)) {
                    if (item.getArchetype().endsWith("Discount")) continue;
                    ObjectSet set = this.createPaymentRefundSet(tillBalanceItem, item);
                    result.add(set);
                }
            }
        }
        this.sort(result);
        return new Page(result, 0, result.size(), result.size());
    }

    private void sort(List<ObjectSet> sets) {
        sets.sort((o1, o2) -> {
            Act a1 = (Act)o1.get(ACT_ITEM);
            Act a2 = (Act)o2.get(ACT_ITEM);
            return this.getPaymentTypeNumber(a1.getArchetype()) - this.getPaymentTypeNumber(a2.getArchetype());
        });
    }

    private ObjectSet createCashAdjustmentSet(FinancialAct adjustment) {
        ObjectSet set = new ObjectSet();
        set.set(BANK_DEPOSIT, (Object)this.bankDeposit);
        set.set(ACT, (Object)adjustment);
        Act item = adjustment.isCredit() ? (Act)this.service.create("act.customerAccountPaymentCash", FinancialAct.class) : (Act)this.service.create("act.customerAccountRefundCash", FinancialAct.class);
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        BigDecimal amount = this.getAmount((Act)adjustment);
        itemBean.setValue(AMOUNT, (Object)amount);
        item.setDescription(adjustment.getDescription());
        set.set(ACT_ITEM, (Object)item);
        set.set(AMOUNT, (Object)amount.negate());
        return set;
    }

    private ObjectSet createPaymentRefundSet(FinancialAct paymentRefund, Act item) {
        ObjectSet set = new ObjectSet();
        set.set(BANK_DEPOSIT, (Object)this.bankDeposit);
        set.set(ACT, (Object)paymentRefund);
        set.set(ACT_ITEM, (Object)item);
        set.set(AMOUNT, (Object)this.getAmount(item).negate());
        return set;
    }

    private BigDecimal getAmount(Act act) {
        return this.calculator.getAmount(act, AMOUNT);
    }

    private int getPaymentTypeNumber(String shortName) {
        if (shortName.endsWith("Cheque")) {
            return 0;
        }
        if (shortName.endsWith("Credit")) {
            return 1;
        }
        if (shortName.endsWith("EFT")) {
            return 2;
        }
        if (shortName.endsWith("Cash")) {
            return 3;
        }
        return 4;
    }
}

