/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.deposit;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.CollectionNodeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;
import org.openvpms.component.system.common.query.RelationalOp;

public class DepositHelper {
    private DepositHelper() {
    }

    public static FinancialAct getUndepositedDeposit(Entity account, IArchetypeService service) {
        ArchetypeQuery query = new ArchetypeQuery("act.bankDeposit", false, true);
        query.setMaxResults(1);
        query.add((IConstraint)new NodeConstraint("status", RelationalOp.EQ, new Object[]{"UNDEPOSITED"}));
        CollectionNodeConstraint participations = new CollectionNodeConstraint("depositAccount", "participation.deposit", false, true);
        participations.add((IConstraint)new ObjectRefNodeConstraint("entity", account.getObjectReference()));
        query.add((IConstraint)participations);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (FinancialAct)iterator.next() : null;
    }

    public static Act createBankDeposit(Entity account, IArchetypeService service) {
        Act act = (Act)service.create("act.bankDeposit", Act.class);
        IMObjectBean bean = service.getBean((IMObject)act);
        bean.setTarget("depositAccount", (IMObject)account);
        return act;
    }
}

