/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class CustomerBalanceUpdater {
    private final IArchetypeService service;
    private final BalanceCalculator calculator;
    private final InsuranceRules rules;
    private static final String CUSTOMER = "customer";
    private static final String ACCOUNT_BALANCE = "accountBalance";

    public CustomerBalanceUpdater(IArchetypeService service) {
        this(service, null);
    }

    public CustomerBalanceUpdater(IArchetypeService service, InsuranceRules rules) {
        this.service = service;
        this.calculator = new BalanceCalculator(service);
        this.rules = rules;
    }

    public boolean hasAccountActs(Reference customer) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, CustomerAccountArchetypes.ACCOUNT_ACTS);
        query.setMaxResults(1);
        query.add((IConstraint)new NodeSelectConstraint("id"));
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext();
    }

    public void checkInitialBalance(FinancialAct initialBalance) {
        IMObjectBean bean;
        Reference customer;
        if (initialBalance.isNew() && (customer = (bean = this.service.getBean((IMObject)initialBalance)).getTargetRef(CUSTOMER)) != null && this.hasAccountActs(customer)) {
            throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.CannotCreateInitialBalance, new Object[0]);
        }
    }

    public void addToBalance(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (this.hasBalanceParticipation(bean)) {
            if (this.calculator.isAllocated(act)) {
                bean.removeValues(ACCOUNT_BALANCE);
            }
        } else if (!this.calculator.isAllocated(act)) {
            this.addBalanceParticipation(bean);
        }
    }

    public void updateBalance(FinancialAct act) {
        if ("POSTED".equals(act.getStatus())) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            if (this.hasBalanceParticipation(act)) {
                Reference customer = bean.getTargetRef(CUSTOMER);
                if (customer == null) {
                    throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.MissingCustomer, act);
                }
                this.updateBalance(act, customer);
            }
        }
    }

    public boolean inBalance(FinancialAct act) {
        boolean result = this.hasBalanceParticipation(act);
        if (!result) {
            result = this.calculator.isAllocated(act);
        }
        return result;
    }

    public List<FinancialAct> updateBalance(FinancialAct act, Iterator<FinancialAct> unallocated) {
        return this.updateBalance(act, unallocated, true);
    }

    public List<FinancialAct> updateBalance(FinancialAct act, Iterator<FinancialAct> unallocated, boolean save) {
        ArrayList<BalanceAct> debits = new ArrayList<BalanceAct>();
        ArrayList<BalanceAct> credits = new ArrayList<BalanceAct>();
        if (act != null && "POSTED".equals(act.getStatus())) {
            this.add(act, debits, credits);
        }
        while (unallocated.hasNext()) {
            FinancialAct a = unallocated.next();
            if (!"POSTED".equals(a.getStatus())) continue;
            this.add(a, debits, credits);
        }
        ArrayList<FinancialAct> modified = new ArrayList<FinancialAct>();
        for (BalanceAct credit : credits) {
            ListIterator iter = debits.listIterator();
            while (iter.hasNext()) {
                BalanceAct debit = (BalanceAct)iter.next();
                this.allocate(credit, debit);
                if (debit.isAllocated()) {
                    iter.remove();
                }
                if (!debit.isDirty()) continue;
                modified.add(debit.getAct());
            }
            if (!credit.isDirty()) continue;
            modified.add(credit.getAct());
        }
        if (save && !modified.isEmpty()) {
            this.service.save(modified);
        }
        return modified;
    }

    protected void add(FinancialAct act, List<BalanceAct> debits, List<BalanceAct> credits) {
        if (act.isCredit()) {
            if (act.getTotal().signum() != -1) {
                credits.add(new BalanceAct(act));
            } else {
                debits.add(new BalanceAct(act));
            }
        } else if (act.getTotal().signum() != -1) {
            debits.add(new BalanceAct(act));
        } else {
            credits.add(new BalanceAct(act));
        }
    }

    protected Iterator<FinancialAct> getUnallocatedActs(Reference customer, Act exclude) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createUnallocatedQuery(customer, CustomerAccountArchetypes.DEBITS_CREDITS, exclude);
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected Predicate<FinancialAct> includes() {
        return this::include;
    }

    protected boolean include(FinancialAct act) {
        return !this.isInvoiceInGapClaim(act);
    }

    private boolean isInvoiceInGapClaim(FinancialAct act) {
        boolean result = false;
        if (this.rules != null && act.isA("act.customerAccountChargesInvoice")) {
            result = this.rules.hasCurrentGapClaims(act);
        }
        return result;
    }

    private void updateBalance(FinancialAct act, Reference customer) {
        Predicate<FinancialAct> includes = this.includes();
        if (includes.evaluate((Object)act)) {
            Iterator<FinancialAct> unallocated = this.getUnallocatedActs(customer, (Act)act);
            FilterIterator filtered = new FilterIterator(unallocated, includes);
            this.updateBalance(act, (Iterator<FinancialAct>)filtered);
        }
    }

    private void addBalanceParticipation(IMObjectBean act) {
        Reference customer = act.getTargetRef(CUSTOMER);
        if (customer == null) {
            throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.MissingCustomer, act.getObject());
        }
        act.setTarget(ACCOUNT_BALANCE, customer);
    }

    private boolean hasBalanceParticipation(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return this.hasBalanceParticipation(bean);
    }

    private boolean hasBalanceParticipation(IMObjectBean act) {
        return act.getTargetRef(ACCOUNT_BALANCE) != null;
    }

    private void allocate(BalanceAct credit, BalanceAct debit) {
        BigDecimal creditToAlloc = credit.getAllocatable();
        if (creditToAlloc.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal debitToAlloc = debit.getAllocatable();
            if (creditToAlloc.compareTo(debitToAlloc) <= 0) {
                debit.addAllocated(creditToAlloc);
                debit.addRelationship(credit, creditToAlloc);
                credit.addAllocated(creditToAlloc);
            } else {
                debit.addAllocated(debitToAlloc);
                debit.addRelationship(credit, debitToAlloc);
                credit.addAllocated(debitToAlloc);
            }
        }
    }

    class BalanceAct {
        private final FinancialAct act;
        private boolean dirty;

        BalanceAct(FinancialAct act) {
            this.act = act;
        }

        public void addRelationship(BalanceAct credit, BigDecimal allocated) {
            IMObjectBean debitBean = CustomerBalanceUpdater.this.service.getBean((IMObject)this.act);
            Relationship relationship = debitBean.addTarget("allocation", (IMObject)credit.getAct(), "allocation");
            IMObjectBean relBean = CustomerBalanceUpdater.this.service.getBean((IMObject)relationship);
            relBean.setValue("allocatedAmount", (Object)allocated);
        }

        public boolean isCredit() {
            return this.act.isCredit();
        }

        public FinancialAct getAct() {
            return this.act;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        BigDecimal getAllocatable() {
            return CustomerBalanceUpdater.this.calculator.getAllocatable(this.act);
        }

        boolean isAllocated() {
            return CustomerBalanceUpdater.this.calculator.isAllocated(this.act);
        }

        void addAllocated(BigDecimal allocated) {
            BigDecimal value = this.act.getAllocatedAmount().add(allocated);
            this.act.setAllocatedAmount(value);
            if (this.isAllocated()) {
                IMObjectBean bean = CustomerBalanceUpdater.this.service.getBean((IMObject)this.act);
                bean.removeValues(CustomerBalanceUpdater.ACCOUNT_BALANCE);
            }
            this.dirty = true;
        }
    }
}

