/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import org.openvpms.archetype.rules.act.ActCopyHandler;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

class CustomerActReversalHandler
extends ActCopyHandler {
    static final String[][] TYPE_MAP = new String[][]{{"act.customerAccountChargesInvoice", "act.customerAccountChargesCredit"}, {"act.customerAccountInvoiceItem", "act.customerAccountCreditItem"}, {"actRelationship.customerAccountInvoiceItem", "actRelationship.customerAccountCreditItem"}, {"act.customerAccountChargesCounter", "act.customerAccountChargesCredit"}, {"act.customerAccountCounterItem", "act.customerAccountCreditItem"}, {"actRelationship.customerAccountCounterItem", "actRelationship.customerAccountCreditItem"}, {"act.customerAccountPayment", "act.customerAccountRefund"}, {"actRelationship.customerAccountPaymentItem", "actRelationship.customerAccountRefundItem"}, {"act.customerAccountPaymentCash", "act.customerAccountRefundCash"}, {"act.customerAccountPaymentCheque", "act.customerAccountRefundCheque"}, {"act.customerAccountPaymentCredit", "act.customerAccountRefundCredit"}, {"act.customerAccountPaymentDiscount", "act.customerAccountRefundDiscount"}, {"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT"}, {"act.customerAccountPaymentOther", "act.customerAccountRefundOther"}, {"act.customerAccountDebitAdjust", "act.customerAccountCreditAdjust"}, {"act.customerAccountDebitAdjust", "act.customerAccountBadDebt"}, {"act.customerAccountInitialBalance", "act.customerAccountCreditAdjust"}};

    CustomerActReversalHandler(Act act) {
        super(TYPE_MAP);
        this.setReverse(act.isA(new String[]{"act.customerAccountChargesCredit", "act.customerAccountRefund", "act.customerAccountCreditAdjust", "act.customerAccountBadDebt"}));
    }

    @Override
    public IMObject getObject(IMObject object, ArchetypeService service) {
        IMObject result = super.getObject(object, service);
        if (object.isA("act.customerAccountRefundCash") && result.isA("act.customerAccountPaymentCash")) {
            IMObjectBean refund = service.getBean(object);
            IMObjectBean payment = service.getBean(result);
            payment.setValue("tendered", (Object)refund.getBigDecimal("roundedAmount"));
        }
        return result;
    }

    @Override
    protected boolean isCopyable(ArchetypeDescriptor archetype, NodeDescriptor node, boolean source) {
        String name = node.getName();
        if ("credit".equals(name) || "allocatedAmount".equals(name) || "accountBalance".equals(name) || "allocation".equals(name) || "reversals".equals(name) || "reverses".equals(name) || "estimates".equals(name) || "hide".equals(name) || "tillBalance".equals(name) || "audit".equals(name) || "eft".equals(name)) {
            return false;
        }
        return super.isCopyable(archetype, node, source);
    }
}

