/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;
import org.openvpms.archetype.rules.finance.account.CustomerActReversalHandler;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceUpdater;
import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.archetype.rules.finance.till.TillBalanceRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.AndConstraint;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.RelationalOp;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class CustomerAccountRules {
    private final IArchetypeService service;
    private final IArchetypeRuleService ruleService;
    private final CustomerBalanceUpdater updater;
    private final PlatformTransactionManager transactionManager;
    private final BalanceCalculator calculator;
    private static final String ID = "id";
    private static final String START_TIME = "startTime";
    private static final String STATUS = "status";
    private static final String TYPE = "type";
    private static final String REVERSAL = "reversal";
    private static final String REVERSES = "reverses";
    private static final String HIDE = "hide";
    private static final String NOTES = "notes";
    private static final String CUSTOMER = "customer";
    private static final String ITEMS = "items";

    public CustomerAccountRules(IArchetypeService service, IArchetypeRuleService ruleService, CustomerBalanceUpdater updater, PlatformTransactionManager transactionManager) {
        if (service instanceof IArchetypeRuleService) {
            throw new IllegalArgumentException("Argument 'service' should not implement IArchetypeRuleService");
        }
        this.service = service;
        this.ruleService = ruleService;
        this.updater = updater;
        this.transactionManager = transactionManager;
        this.calculator = new BalanceCalculator(service);
    }

    public BigDecimal calculateTotal(BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal quantity, BigDecimal discount) {
        return MathRules.calculateTotal(fixedPrice, unitPrice, quantity, discount, 2);
    }

    public FinancialAct getOpeningBalanceBefore(Party customer, Date date) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, "act.customerAccountOpeningBalance");
        query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)date));
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)false));
        query.add((IConstraint)Constraints.sort((String)ID, (boolean)false));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (FinancialAct)iterator.next() : null;
    }

    public FinancialAct getOpeningBalanceAfter(Party customer, Date date) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, "act.customerAccountOpeningBalance");
        query.add((IConstraint)Constraints.gt((String)START_TIME, (Object)date));
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)true));
        query.add((IConstraint)Constraints.sort((String)ID, (boolean)false));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (FinancialAct)iterator.next() : null;
    }

    public FinancialAct createOpeningBalance(Party customer, Date date, BigDecimal amount) {
        return this.createBalance("act.customerAccountOpeningBalance", customer, date, amount);
    }

    public FinancialAct createClosingBalance(Party customer, Date date, BigDecimal amount) {
        return this.createBalance("act.customerAccountClosingBalance", customer, date, amount);
    }

    public BigDecimal getBalance(Party customer) {
        return this.calculator.getBalance(customer);
    }

    public BigDecimal getBalance(Party customer, Date date) {
        return this.calculator.getBalance(customer, date);
    }

    public BigDecimal getBalance(Party customer, Date from, Date to, BigDecimal openingBalance) {
        return this.getBalance(customer, from, to, true, openingBalance);
    }

    public BigDecimal getBalance(Party customer, Date from, Date to, boolean inclusive, BigDecimal openingBalance) {
        return this.calculator.getBalance(customer, from, to, inclusive, openingBalance);
    }

    public BigDecimal getDefinitiveBalance(Party customer) {
        return this.calculator.getDefinitiveBalance(customer);
    }

    public BigDecimal getBalance(Party customer, BigDecimal total, boolean payment) {
        BigDecimal balance = this.getBalance(customer);
        BigDecimal result = payment ? balance.subtract(total) : balance.add(total);
        if (result.signum() == -1) {
            result = payment ? BigDecimal.ZERO : result.negate();
        } else if (result.signum() == 1 && !payment) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    public BigDecimal getOverdueBalance(Party customer, Date date) {
        Date overdue = this.getOverdueDate(customer, date);
        return this.calculator.getOverdueBalance(customer, overdue);
    }

    public BigDecimal getOverdueBalance(Party customer, Date date, Date overdueDate) {
        return this.calculator.getOverdueBalance(customer, date, overdueDate);
    }

    public boolean hasOverdueBalance(Party customer, Date date, int from, int to) {
        Date overdue;
        Date overdueFrom = overdue = this.getOverdueDate(customer, date);
        Date overdueTo = null;
        if (from > 0) {
            overdueFrom = DateRules.getDate(overdueFrom, -from, DateUnits.DAYS);
        }
        if (to > 0) {
            overdueTo = DateRules.getDate(overdue, -to, DateUnits.DAYS);
        }
        ArchetypeQuery query = CustomerAccountQueryFactory.createUnallocatedObjectSetQuery(customer, CustomerAccountArchetypes.DEBITS);
        NodeConstraint fromStartTime = new NodeConstraint(START_TIME, RelationalOp.LT, new Object[]{overdueFrom});
        if (overdueTo == null) {
            query.add((IConstraint)fromStartTime);
        } else {
            NodeConstraint toStartTime = new NodeConstraint(START_TIME, RelationalOp.GT, new Object[]{overdueTo});
            AndConstraint and = new AndConstraint();
            and.add((IConstraint)fromStartTime);
            and.add((IConstraint)toStartTime);
            query.add((IConstraint)and);
        }
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext();
    }

    public Date getOverdueDate(Party customer, Date date) {
        List types;
        IMObjectBean bean = this.service.getBean((IMObject)customer);
        Date overdue = date;
        if (bean.hasNode(TYPE) && !(types = bean.getValues(TYPE, Lookup.class)).isEmpty()) {
            overdue = this.getOverdueDate((Lookup)types.get(0), date);
        }
        return overdue;
    }

    public Date getOverdueDate(Lookup type, Date date) {
        return new AccountType(type, (ArchetypeService)this.service).getOverdueDate(date);
    }

    public BigDecimal getUnbilledAmount(Party customer) {
        return this.calculator.getUnbilledAmount(customer);
    }

    public boolean isReversed(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.hasNode(REVERSAL) && !bean.getValues(REVERSAL).isEmpty();
    }

    public boolean isReversal(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.hasNode(REVERSES) && !bean.getValues(REVERSES).isEmpty();
    }

    public FinancialAct reverse(FinancialAct act, Date startTime) {
        return this.reverse(act, startTime, null, null, false);
    }

    public FinancialAct reverse(FinancialAct act, Date startTime, String notes, String reference, boolean hide) {
        return this.reverse(act, startTime, notes, reference, hide, null);
    }

    public FinancialAct reverse(final FinancialAct act, Date startTime, String notes, String reference, boolean hide, final FinancialAct tillBalance) {
        TillBalanceRules rules;
        if (!"POSTED".equals(act.getStatus())) {
            throw new IllegalStateException("Cannot reverse act with status " + act.getStatus());
        }
        IMObjectBean original = this.service.getBean((IMObject)act);
        if (!original.getValues(REVERSAL).isEmpty()) {
            throw new IllegalStateException("Act=" + act.getId() + " has already been reversed");
        }
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new CustomerActReversalHandler((Act)act), (ArchetypeService)this.service);
        final List objects = copier.apply((IMObject)act);
        FinancialAct reversal = (FinancialAct)objects.get(0);
        IMObjectBean bean = this.service.getBean((IMObject)reversal);
        bean.setValue("reference", !StringUtils.isEmpty((CharSequence)reference) ? reference : Long.valueOf(act.getId()));
        bean.setValue(NOTES, (Object)notes);
        reversal.setStatus("POSTED");
        reversal.setActivityStartTime(startTime);
        original.addTarget(REVERSAL, (IMObject)reversal, REVERSES);
        this.updater.updateBalance(act, Collections.singletonList(reversal).iterator(), false);
        if (hide && !original.getBoolean(HIDE)) {
            bean.setValue(HIDE, (Object)true);
            original.setValue(HIDE, (Object)true);
        }
        boolean updateBalance = tillBalance != null && bean.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"});
        TillBalanceRules tillBalanceRules = rules = updateBalance ? new TillBalanceRules(this.service) : null;
        if (updateBalance) {
            List<Act> changed = rules.addToBalance((Act)reversal, (Act)tillBalance);
            objects.addAll(changed);
        }
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ArrayList<FinancialAct> noRules = new ArrayList<FinancialAct>();
                noRules.add(act);
                if (act.isA("act.customerAccountChargesInvoice")) {
                    CustomerAccountRules.this.removeInvoiceFromPatientHistory(act, noRules);
                }
                CustomerAccountRules.this.service.save(noRules);
                CustomerAccountRules.this.ruleService.save((Collection)objects);
                if (rules != null) {
                    rules.updateBalance(tillBalance);
                }
            }
        });
        return reversal;
    }

    public String getReversalArchetype(String archetype) {
        for (String[] pair : CustomerActReversalHandler.TYPE_MAP) {
            if (pair[0].equals(archetype)) {
                return pair[1];
            }
            if (!pair[1].equals(archetype)) continue;
            return pair[0];
        }
        return null;
    }

    public boolean isAllocated(FinancialAct act) {
        return this.calculator.isAllocated(act);
    }

    public void setHidden(FinancialAct act, boolean hide) {
        IMObjectBean bean;
        if (this.canHide(act) && hide != (bean = this.service.getBean((IMObject)act)).getBoolean(HIDE)) {
            bean.setValue(HIDE, (Object)hide);
            this.service.save((IMObject)act);
        }
    }

    public boolean isHidden(Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.hasNode(HIDE) && bean.getBoolean(HIDE);
    }

    public boolean canHide(FinancialAct act) {
        return this.isReversed(act) || this.isReversal(act);
    }

    public FinancialAct getInvoice(Party customer) {
        return this.getInvoice(customer.getObjectReference());
    }

    public FinancialAct getInvoice(Reference customer) {
        return this.getCharge("act.customerAccountChargesInvoice", customer);
    }

    public FinancialAct getCredit(Party customer) {
        return this.getCredit(customer.getObjectReference());
    }

    public FinancialAct getCredit(Reference customer) {
        return this.getCharge("act.customerAccountChargesCredit", customer);
    }

    public boolean hasAccountActs(Party customer) {
        return this.updater.hasAccountActs(customer.getObjectReference());
    }

    public FinancialAct createCreditAdjustment(Party customer, BigDecimal total, Party location, Party practice, String notes) {
        CustomerTaxRules taxRules = new CustomerTaxRules(practice, this.service);
        FinancialAct act = (FinancialAct)this.service.create("act.customerAccountCreditAdjust", FinancialAct.class);
        act.setTotal(total);
        act.setStatus("POSTED");
        IMObjectBean bean = this.ruleService.getBean((IMObject)act);
        bean.setTarget(CUSTOMER, (IMObject)customer);
        if (location != null) {
            bean.setTarget("location", (IMObject)location);
        }
        if (notes != null) {
            bean.setValue(NOTES, (Object)notes);
        }
        taxRules.calculateTax(act);
        return act;
    }

    public List<FinancialAct> createPaymentOther(Party customer, BigDecimal total, Entity till, Party location, String paymentType, String notes) {
        FinancialAct act = (FinancialAct)this.service.create("act.customerAccountPayment", FinancialAct.class);
        FinancialAct item = (FinancialAct)this.service.create("act.customerAccountPaymentOther", FinancialAct.class);
        act.setStatus("POSTED");
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget(CUSTOMER, (IMObject)customer);
        bean.setValue("amount", (Object)total);
        bean.setTarget("till", (IMObject)till);
        bean.setTarget("location", (IMObject)location);
        if (notes != null) {
            bean.setValue(NOTES, (Object)notes);
        }
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        itemBean.setValue("amount", (Object)total);
        if (paymentType != null) {
            itemBean.setValue("paymentType", (Object)paymentType);
        }
        ActRelationship relationship = (ActRelationship)bean.addTarget(ITEMS, (IMObject)item);
        item.addActRelationship(relationship);
        return Arrays.asList(act, item);
    }

    public boolean hasClearedTillBalance(FinancialAct payment) {
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)payment);
        Reference balance = bean.getSourceRef("tillBalance");
        if (balance != null) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Long.class);
            Root root = query.from(Act.class, new String[]{"act.tillBalance"});
            query.select((Selection)root.get(ID));
            query.where(new Predicate[]{builder.equal((Expression)root.reference(), (Object)balance), builder.notEqual((Expression)root.get(STATUS), (Object)"CLEARED")});
            if (this.service.createQuery(query).getFirstResult() == null) {
                result = true;
            }
        }
        return result;
    }

    public void post(final FinancialAct act) throws CustomerAccountRuleException {
        if (!act.isA(CustomerAccountArchetypes.DEBITS_CREDITS)) {
            throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.CannotPostAct, DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service));
        }
        if ("POSTED".equals(act.getStatus())) {
            throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.AlreadyPosted, DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service));
        }
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                if (act.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"}) && CustomerAccountRules.this.hasOutstandingEFTPOSTransaction(act, false)) {
                    throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.CannotPostWithOutstandingEFT, DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)CustomerAccountRules.this.service));
                }
                act.setStatus("POSTED");
                act.setActivityStartTime(new Date());
                CustomerAccountRules.this.ruleService.save((IMObject)act);
            }
        });
    }

    public boolean hasOutstandingEFTPOSTransaction(FinancialAct act, boolean ignoreUnsuccessful) {
        boolean result = false;
        List<FinancialAct> items = this.getEFTItems(act);
        for (FinancialAct item : items) {
            List<FinancialAct> transactions = this.getEFTPOSTransactions(item, ignoreUnsuccessful);
            if (transactions.isEmpty()) continue;
            boolean found = false;
            for (FinancialAct eft : transactions) {
                if (!"APPROVED".equals(eft.getStatus()) && !"NO_TERMINAL".equals(eft.getStatus())) continue;
                found = true;
                break;
            }
            if (found) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasApprovedEFTPOSTransaction(FinancialAct act) {
        boolean result = false;
        List<FinancialAct> items = this.getEFTItems(act);
        block0: for (FinancialAct item : items) {
            List<FinancialAct> transactions = this.getEFTPOSTransactions(item, true);
            if (transactions.isEmpty()) continue;
            for (FinancialAct eft : transactions) {
                if (!"APPROVED".equals(eft.getStatus())) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private List<FinancialAct> getEFTItems(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.getTargets(ITEMS, FinancialAct.class, Policies.all((java.util.function.Predicate)Predicates.targetIsA((String[])new String[]{"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT"})));
    }

    private List<FinancialAct> getEFTPOSTransactions(FinancialAct item, boolean ignoreUnsuccessful) {
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        List result = itemBean.getTargets("eft", FinancialAct.class);
        if (ignoreUnsuccessful && !result.isEmpty()) {
            result.removeIf(act -> "DECLINED".equals(act.getStatus()) || "ERROR".equals(act.getStatus()));
        }
        return result;
    }

    private FinancialAct createBalance(String archetype, Party customer, Date date, BigDecimal amount) {
        FinancialAct act = (FinancialAct)this.service.create(archetype, FinancialAct.class);
        act.setActivityStartTime(date);
        if (amount.signum() == -1) {
            amount = amount.negate();
            act.setCredit(!act.isCredit());
        }
        act.setTotal(amount);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget(CUSTOMER, (IMObject)customer);
        return act;
    }

    private void removeInvoiceFromPatientHistory(FinancialAct invoice, List<IMObject> toSave) {
        IMObjectBean bean = this.service.getBean((IMObject)invoice);
        HashMap<Reference, Act> events = new HashMap<Reference, Act>();
        for (Act item : bean.getTargets(ITEMS, Act.class)) {
            IMObjectBean itemBean = this.service.getBean((IMObject)item);
            ActRelationship relationship = (ActRelationship)itemBean.getObject("event", ActRelationship.class);
            if (relationship != null) {
                toSave.add((IMObject)item);
                this.removeEventRelationship(events, item, relationship);
            }
            for (Act medication : itemBean.getTargets("dispensing", Act.class)) {
                if (!this.removeEventRelationship(events, medication)) continue;
                toSave.add((IMObject)medication);
            }
            for (Act investigation : itemBean.getTargets("investigations", Act.class)) {
                if (!this.removeEventRelationship(events, investigation)) continue;
                toSave.add((IMObject)investigation);
            }
            for (Act document : itemBean.getTargets("documents", Act.class)) {
                if (!this.removeEventRelationship(events, document)) continue;
                toSave.add((IMObject)document);
            }
        }
        toSave.addAll(events.values());
    }

    private boolean removeEventRelationship(Map<Reference, Act> events, Act act) {
        boolean changed = false;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        for (ActRelationship eventRelationship : bean.getValues("event", ActRelationship.class)) {
            changed = true;
            this.removeEventRelationship(events, act, eventRelationship);
        }
        return changed;
    }

    private void removeEventRelationship(Map<Reference, Act> events, Act act, ActRelationship relationship) {
        act.removeActRelationship(relationship);
        Reference ref = relationship.getSource();
        Act event = events.computeIfAbsent(ref, reference -> (Act)this.service.get(reference, Act.class));
        if (event != null) {
            event.removeActRelationship(relationship);
        }
    }

    private FinancialAct getCharge(String shortName, Reference customer) {
        FinancialAct result = this.getCharge(shortName, customer, "IN_PROGRESS");
        if (result == null) {
            result = this.getCharge(shortName, customer, "COMPLETED");
        }
        return result;
    }

    private FinancialAct getCharge(String shortName, Reference customer, String status) {
        ArchetypeQuery query = new ArchetypeQuery(shortName, false, true);
        query.setMaxResults(1);
        query.add((IConstraint)Constraints.join((String)CUSTOMER).add((IConstraint)Constraints.eq((String)"entity", (Reference)customer)));
        query.add((IConstraint)Constraints.eq((String)STATUS, (Object)status));
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)false));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (FinancialAct)iterator.next() : null;
    }
}

