/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AccountType {
    private final IMObjectBean bean;

    public AccountType(Lookup lookup, ArchetypeService service) {
        this.bean = service.getBean((IMObject)lookup);
    }

    public String getName() {
        return this.bean.getString("name");
    }

    public int getPaymentTerms() {
        return this.bean.getInt("paymentTerms");
    }

    public DateUnits getPaymentUOM() {
        String value = this.bean.getString("paymentUom");
        return value != null ? DateUnits.valueOf(value) : null;
    }

    public Date getOverdueDate(Date date) {
        DateUnits payment = this.getPaymentUOM();
        if (payment != null) {
            date = DateRules.getDate(date);
            int days = this.getPaymentTerms();
            return DateRules.getDate(date, -days, payment);
        }
        return date;
    }

    public FeeType getFeeType() {
        String type = this.bean.getString("accountFee");
        return "FIXED".equals(type) ? FeeType.FIXED : FeeType.PERCENTAGE;
    }

    public BigDecimal getAccountFeeAmount() {
        return this.bean.getBigDecimal("accountFeeAmount");
    }

    public BigDecimal getAccountFeeMinimum() {
        return this.bean.getBigDecimal("accountFeeMinimum");
    }

    public BigDecimal getAccountFeeBalance() {
        return this.bean.getBigDecimal("accountFeeBalance");
    }

    public int getAccountFeeDays() {
        return this.bean.getInt("accountFeeDays");
    }

    public String getAccountFeeMessage() {
        return this.bean.getString("accountFeeMessage");
    }

    public Date getAccountFeeDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -this.getAccountFeeDays());
        return calendar.getTime();
    }

    public BigDecimal getAccountFee(BigDecimal overdue) {
        BigDecimal amount = this.getAccountFeeAmount();
        if (this.getFeeType() == FeeType.FIXED) {
            return amount;
        }
        return MathRules.divide(amount.multiply(overdue), MathRules.ONE_HUNDRED, 2);
    }

    public Lookup getAlert() {
        return (Lookup)this.bean.getTarget("alert", Lookup.class);
    }

    public static enum FeeType {
        FIXED,
        PERCENTAGE;

    }
}

