/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DefaultDocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class SupportedContentDocumentHandler
implements DocumentHandler {
    private final String[] supportedExtensions;
    private final String[] supportedMimeTypes;
    private final String documentArchetype;
    private final DocumentHandler handler;

    public SupportedContentDocumentHandler(String[] supportedExtensions, String[] supportedMimeTypes, ArchetypeService service) {
        this(supportedExtensions, supportedMimeTypes, "document.other", service);
    }

    public SupportedContentDocumentHandler(String[] supportedExtensions, String[] supportedMimeTypes, String documentArchetype, ArchetypeService service) {
        this(supportedExtensions, supportedMimeTypes, documentArchetype, new DefaultDocumentHandler(documentArchetype, service));
    }

    public SupportedContentDocumentHandler(String[] supportedExtensions, String[] supportedMimeTypes, String documentArchetype, DocumentHandler handler) {
        this.supportedExtensions = supportedExtensions;
        this.supportedMimeTypes = supportedMimeTypes;
        this.documentArchetype = documentArchetype;
        this.handler = handler;
    }

    @Override
    public boolean canHandle(String name, String mimeType) {
        return this.isSupportedExtension(name) || mimeType != null && this.isSupportedMimeType(mimeType);
    }

    @Override
    public boolean canHandle(String name, String archetype, String mimeType) {
        return this.documentArchetype.equals(archetype) && this.canHandle(name, mimeType);
    }

    @Override
    public boolean canHandle(org.openvpms.component.model.document.Document document) {
        return this.documentArchetype.equals(document.getArchetype());
    }

    @Override
    public Document create(String name, InputStream stream, String mimeType, int size) {
        return this.handler.create(name, stream, mimeType, size);
    }

    @Override
    public Document create(String name, byte[] content, String mimeType, int size) {
        return this.handler.create(name, content, mimeType, size);
    }

    @Override
    public void update(Document document, InputStream stream, String mimeType, int size) {
        this.handler.update(document, stream, mimeType, size);
    }

    @Override
    public InputStream getContent(org.openvpms.component.model.document.Document document) {
        return this.handler.getContent(document);
    }

    protected boolean isSupportedExtension(String name) {
        for (String ext : this.supportedExtensions) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)ext)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSupportedMimeType(String mimeType) {
        for (String type : this.supportedMimeTypes) {
            if (!type.equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }
}

