/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.document.Document;

public class DocumentHelper {
    private DocumentHelper() {
    }

    public static Document create(File file, String mimeType, DocumentHandlers factory) {
        DocumentHandler handler = factory.get(file.getName(), mimeType);
        return DocumentHelper.create(file, handler, mimeType);
    }

    public static Document create(File file, String shortName, String mimeType, DocumentHandlers factory) {
        DocumentHandler handler = factory.get(file.getName(), shortName, mimeType);
        return DocumentHelper.create(file, handler, mimeType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document create(File file, DocumentHandler handler, String mimeType) {
        if (handler == null) {
            throw new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, file.getName(), mimeType);
        }
        try (FileInputStream stream = new FileInputStream(file);){
            int length = (int)file.length();
            Document document = handler.create(file.getName(), stream, mimeType, length);
            return document;
        }
        catch (IOException exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, exception, file.getName());
        }
    }
}

