/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;

public class DelegatingDocumentHandler
implements DocumentHandler {
    private final List<DocumentHandler> handlers;

    public DelegatingDocumentHandler(DocumentHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public DelegatingDocumentHandler(List<DocumentHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public boolean canHandle(String name, String mimeType) {
        return this.find(name, mimeType) != null;
    }

    @Override
    public boolean canHandle(String name, String archetype, String mimeType) {
        return this.find(name, archetype, mimeType) != null;
    }

    @Override
    public boolean canHandle(org.openvpms.component.model.document.Document document) {
        boolean result = false;
        for (DocumentHandler handler : this.handlers) {
            if (!handler.canHandle(document)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Document create(String name, InputStream stream, String mimeType, int size) {
        DocumentHandler handler = this.find(name, mimeType);
        if (handler == null) {
            throw new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, name, mimeType);
        }
        return handler.create(name, stream, mimeType, size);
    }

    @Override
    public Document create(String name, byte[] content, String mimeType, int size) {
        DocumentHandler handler = this.find(name, mimeType);
        if (handler == null) {
            throw new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, name, mimeType);
        }
        return handler.create(name, content, mimeType, size);
    }

    @Override
    public void update(Document document, InputStream stream, String mimeType, int size) {
        String name = document.getName();
        DocumentHandler handler = this.find(name, mimeType);
        if (handler == null) {
            throw new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, name, mimeType);
        }
        handler.update(document, stream, mimeType, size);
    }

    @Override
    public InputStream getContent(org.openvpms.component.model.document.Document document) {
        String mimeType;
        String name = document.getName();
        DocumentHandler handler = this.find(name, mimeType = document.getMimeType());
        if (handler == null) {
            throw new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, name, mimeType);
        }
        return handler.getContent(document);
    }

    public DocumentHandler find(String name, String mimeType) {
        DocumentHandler result = null;
        for (DocumentHandler handler : this.handlers) {
            if (!handler.canHandle(name, mimeType)) continue;
            result = handler;
            break;
        }
        return result;
    }

    public DocumentHandler find(String name, String archetype, String mimeType) {
        DocumentHandler result = null;
        for (DocumentHandler handler : this.handlers) {
            if (!handler.canHandle(name, archetype, mimeType)) continue;
            result = handler;
            break;
        }
        return result;
    }
}

