/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.nio.charset.StandardCharsets;
import org.openvpms.archetype.rules.doc.AbstractDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractTextDocumentHandler
extends AbstractDocumentHandler {
    protected AbstractTextDocumentHandler(String archetype, ArchetypeService service) {
        super(archetype, service, false);
    }

    public Document create(String name, String content, String mimeType) {
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        return this.create(name, bytes, mimeType, bytes.length);
    }

    public void update(Document document, String content) {
        byte[] bytes = content != null ? content.getBytes(StandardCharsets.UTF_8) : new byte[]{};
        int length = content != null ? content.length() : 0;
        this.update(document, document.getName(), bytes, document.getMimeType(), length, this.calculateChecksum(bytes));
    }

    public String toString(Document document) {
        return AbstractTextDocumentHandler.asString(document);
    }

    public static String asString(Document document) {
        byte[] bytes = document.getContents();
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

