/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.contact;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public abstract class AbstractAddressFormatter
implements AddressFormatter {
    private final ArchetypeService service;
    private final LookupService lookups;

    protected AbstractAddressFormatter(ArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    @Override
    public String format(Contact location, boolean singleLine) {
        IMObjectBean bean = this.service.getBean((IMObject)location);
        String address = bean.getString("address");
        String suburb = this.lookups.getName((IMObject)location, "suburb");
        String stateName = this.lookups.getName((IMObject)location, "state");
        String stateCode = bean.getString("state");
        String postcode = bean.getString("postcode");
        return this.format(location, address, suburb, stateCode, stateName, postcode, singleLine);
    }

    protected String format(Contact location, String address, String suburb, String stateCode, String stateName, String postcode, boolean singleLine) {
        return this.formatDefault(address, suburb, stateName, postcode, singleLine);
    }

    protected String formatDefault(String address, String suburb, String state, String postcode, boolean singleLine) {
        StringBuilder result = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)address)) {
            if (singleLine) {
                result.append(address.replace('\n', ' '));
                result.append(", ");
            } else {
                result.append(address);
                result.append("\n");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)suburb)) {
            result.append(suburb);
            result.append(" ");
        }
        if (!StringUtils.isEmpty((CharSequence)state)) {
            result.append(state);
            result.append(" ");
        }
        if (!StringUtils.isEmpty((CharSequence)postcode)) {
            result.append(postcode);
        }
        return result.toString();
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected LookupService getLookups() {
        return this.lookups;
    }
}

