/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n.time;

import java.util.Collection;
import java.util.Date;
import org.openvpms.archetype.i18n.time.CompositeDurationFormatter;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.i18n.time.DurationFormatter;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupDateDurationFormatter
implements DurationFormatter {
    public static final String DURATION_FORMATS = "lookup.durationformats";
    public static final String DURATION_FORMAT = "lookup.durationformat";
    public static final String DURATION_FORMATS_RELATIONSHIP = "lookupRelationship.durationformats";
    private final CompositeDurationFormatter formatter = new CompositeDurationFormatter();
    private static final Logger log = LoggerFactory.getLogger(LookupDateDurationFormatter.class);

    public LookupDateDurationFormatter(Lookup formats, LookupService lookupService, ArchetypeService service) {
        Collection lookups = lookupService.getTargetLookups(formats, DURATION_FORMATS_RELATIONSHIP);
        for (Lookup lookup : lookups) {
            IMObjectBean bean = service.getBean((IMObject)lookup);
            int interval = bean.getInt("interval");
            DateUnits units = DateUnits.valueOf(bean.getString("units"));
            boolean showYears = bean.getBoolean("showYears");
            boolean showMonths = bean.getBoolean("showMonths");
            boolean showWeeks = bean.getBoolean("showWeeks");
            boolean showDays = bean.getBoolean("showDays");
            if (showYears || showMonths || showWeeks || showDays) {
                this.formatter.add(interval, units, DateDurationFormatter.create(showYears, showMonths, showWeeks, showDays));
                continue;
            }
            log.warn("Skipping duration format {} ({})): no fields displayed", (Object)lookup.getName(), (Object)lookup.getId());
        }
    }

    @Override
    public String format(Date from, Date to) {
        return this.formatter.format(from, to);
    }
}

