/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.user;

import java.net.URL;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserFunctions
extends AbstractObjectFunctions {
    private final UserRules userRules;
    private final ArchetypeService service;
    private final PracticeService practiceService;
    private final LookupService lookups;
    private final ImageService imageService;
    private final Functions functions;
    private static final Logger log = LoggerFactory.getLogger(UserFunctions.class);
    private static final String USERNAME = "username";
    private static final String TITLE = "title";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String QUALIFICATIONS = "qualifications";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";

    public UserFunctions(UserRules userRules, ArchetypeService service, PracticeService practiceService, LookupService lookups, ImageService imageService, Functions functions) {
        super("user");
        this.setObject((Object)this);
        this.userRules = userRules;
        this.service = service;
        this.practiceService = practiceService;
        this.lookups = lookups;
        this.imageService = imageService;
        this.functions = functions;
    }

    public String format(User user, String style) {
        String result = null;
        if (user != null) {
            result = "short".equalsIgnoreCase(style) ? this.formatName(user, "shortUserNameFormat") : ("medium".equalsIgnoreCase(style) ? this.formatName(user, "mediumUserNameFormat") : this.formatName(user, "longUserNameFormat"));
        }
        return result;
    }

    public String formatById(long id, String style) {
        User user = this.getUser(id);
        return user != null ? this.format(user, style) : null;
    }

    public URL signature(Object object) {
        URL result = null;
        if (object instanceof User) {
            User user = (User)object;
            result = this.getSignature(user);
        } else if (object instanceof Number) {
            long id = ((Number)object).longValue();
            User user = this.getUser(id);
            result = this.getSignature(user);
        }
        return result;
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        if ("format".equals(name) && parameters.length >= 1 && parameters[0] instanceof Number) {
            name = "formatById";
        }
        return super.getFunction(namespace, name, parameters);
    }

    private URL getSignature(User user) {
        URL result = null;
        try {
            DocumentAct signature = this.userRules.getSignature(user);
            if (signature != null) {
                result = this.imageService.getURL(signature);
            }
        }
        catch (Exception exception) {
            log.warn("Failed to retrieve signature for {}: {}", new Object[]{user.getUsername(), exception.getMessage(), exception});
        }
        return result;
    }

    private String formatName(User user, String node) {
        IMObjectBean bean;
        String expression;
        Lookup lookup;
        String result = null;
        Party practice = this.practiceService.getPractice();
        if (practice != null && (lookup = this.lookups.getLookup((IMObject)practice, node)) != null && (expression = (bean = this.service.getBean((IMObject)lookup)).getString("expression")) != null) {
            try {
                IMObjectBean userBean = this.service.getBean((IMObject)user);
                JXPathContext context = JXPathHelper.newContext((Object)user, (Functions)this.functions);
                Variables variables = context.getVariables();
                variables.declareVariable(USERNAME, userBean.getValue(USERNAME));
                variables.declareVariable(TITLE, (Object)this.lookups.getName((IMObject)user, TITLE));
                variables.declareVariable(FIRST_NAME, userBean.getValue(FIRST_NAME));
                variables.declareVariable(LAST_NAME, userBean.getValue(LAST_NAME));
                variables.declareVariable(QUALIFICATIONS, userBean.getValue(QUALIFICATIONS));
                variables.declareVariable(NAME, userBean.getValue(NAME));
                variables.declareVariable(DESCRIPTION, userBean.getValue(DESCRIPTION));
                Object value = context.getValue(expression);
                if (value != null) {
                    result = value.toString();
                }
            }
            catch (Exception exception) {
                log.warn(exception.getMessage(), (Throwable)exception);
            }
        }
        if (result == null) {
            result = user.getName();
        }
        return result;
    }

    private User getUser(long id) {
        return (User)this.service.get("security.user", id, User.class);
    }
}

