/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.product;

import java.math.BigDecimal;
import org.apache.commons.jxpath.Function;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class ProductFunctions
extends AbstractObjectFunctions {
    private final ProductPriceRules priceRules;
    private final PracticeService practiceService;
    private final IArchetypeService service;

    public ProductFunctions(ProductPriceRules priceRules, PracticeService practiceService, IArchetypeService service) {
        super("product");
        this.setObject((Object)this);
        this.priceRules = priceRules;
        this.practiceService = practiceService;
        this.service = service;
    }

    public BigDecimal priceById(long productId, BigDecimal taxExPrice) {
        Product product;
        BigDecimal result;
        BigDecimal bigDecimal = result = taxExPrice != null ? taxExPrice : BigDecimal.ZERO;
        if (!MathRules.isZero(result) && (product = this.getProduct(productId)) != null) {
            result = this.price(product, taxExPrice);
        }
        return result;
    }

    public BigDecimal priceById(long productId, BigDecimal taxExPrice, boolean taxInclusive) {
        BigDecimal result;
        BigDecimal bigDecimal = result = taxExPrice != null ? taxExPrice : BigDecimal.ZERO;
        if (!MathRules.isZero(result)) {
            Product product;
            result = taxInclusive ? ((product = this.getProduct(productId)) != null ? this.price(product, taxExPrice, true) : this.round(taxExPrice)) : this.round(taxExPrice);
        }
        return result;
    }

    public BigDecimal price(Product product, BigDecimal taxExPrice) {
        Party practice;
        BigDecimal result;
        BigDecimal bigDecimal = result = taxExPrice != null ? taxExPrice : BigDecimal.ZERO;
        if (!MathRules.isZero(result) && product != null && (practice = this.practiceService.getPractice()) != null) {
            boolean taxInclusive = this.isTaxInclusive(practice);
            result = this.getPrice(product, taxExPrice, taxInclusive, practice);
        }
        return result;
    }

    public BigDecimal price(Product product, BigDecimal taxExPrice, boolean taxInclusive) {
        Party practice;
        BigDecimal result;
        BigDecimal bigDecimal = result = taxExPrice != null ? taxExPrice : BigDecimal.ZERO;
        if (!MathRules.isZero(result) && product != null && (practice = this.practiceService.getPractice()) != null) {
            result = this.getPrice(product, taxExPrice, taxInclusive, practice);
        }
        return result;
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        if ("price".equals(name) && parameters.length >= 1 && parameters[0] instanceof Number) {
            name = "priceById";
        } else if ("taxRate".equals(name) && parameters.length == 1 && parameters[0] instanceof Number) {
            name = "taxRateById";
        }
        return super.getFunction(namespace, name, parameters);
    }

    public BigDecimal taxRateById(long productId) {
        Product product = this.getProduct(productId);
        return product != null ? this.taxRate(product) : BigDecimal.ZERO;
    }

    public BigDecimal taxRate(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        Party practice = this.practiceService.getPractice();
        if (product != null && practice != null) {
            result = this.priceRules.getTaxRate(product, practice);
        }
        return result;
    }

    public BigDecimal round(BigDecimal price) {
        BigDecimal result = price != null ? price : BigDecimal.ZERO;
        Currency currency = this.practiceService.getCurrency();
        if (currency != null) {
            result = currency.round(price);
        }
        return result;
    }

    protected boolean isTaxInclusive(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        return bean.getBoolean("showPricesTaxInclusive", true);
    }

    private BigDecimal getPrice(Product product, BigDecimal taxExPrice, boolean taxInclusive, Party practice) {
        BigDecimal result = taxExPrice;
        Currency currency = this.practiceService.getCurrency();
        if (currency != null) {
            result = taxInclusive ? this.priceRules.getTaxIncPrice(taxExPrice, product, practice, currency) : currency.round(taxExPrice);
        }
        return result;
    }

    private Product getProduct(long productId) {
        ArchetypeQuery query = new ArchetypeQuery("product.*", false);
        String alias = "p";
        query.getArchetypeConstraint().setAlias(alias);
        query.add((IConstraint)Constraints.eq((String)"id", (Object)productId));
        query.add((IConstraint)new ObjectRefSelectConstraint(alias));
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        if (iterator.hasNext()) {
            IMObjectReference reference = ((ObjectSet)iterator.next()).getReference("p.reference");
            return (Product)this.service.get((Reference)reference, Product.class);
        }
        return null;
    }
}

