/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.factory;

import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.archetype.rules.contact.BasicAddressFormatter;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.archetype.rules.doc.LogoService;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.patient.PatientAgeFormatter;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultArchetypeFunctionsFactory
extends ArchetypeFunctionsFactory {
    private final IArchetypeService service;
    private final PracticeService practiceService;
    private final LookupService lookups;
    private final Currencies currencies;
    private final AddressFormatter addressFormatter;
    private final PatientAgeFormatter ageFormatter;
    private final ImageService imageService;
    private final LogoService logoService;
    private final PlatformTransactionManager transactionManager;

    public DefaultArchetypeFunctionsFactory(IArchetypeService service, LookupService lookups, PracticeService practiceService, Currencies currencies, PatientAgeFormatter ageFormatter, ImageService imageService, LogoService logoService, PlatformTransactionManager transactionManager) {
        this(service, lookups, practiceService, currencies, new BasicAddressFormatter((ArchetypeService)service, lookups), ageFormatter, imageService, logoService, transactionManager);
    }

    public DefaultArchetypeFunctionsFactory(IArchetypeService service, LookupService lookups, PracticeService practiceService, Currencies currencies, AddressFormatter addressFormatter, PatientAgeFormatter ageFormatter, ImageService imageService, LogoService logoService, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.lookups = lookups;
        this.practiceService = practiceService;
        this.currencies = currencies;
        this.addressFormatter = addressFormatter;
        this.ageFormatter = ageFormatter;
        this.imageService = imageService;
        this.logoService = logoService;
        this.transactionManager = transactionManager;
    }

    @Override
    protected IArchetypeService getArchetypeService() {
        return this.service;
    }

    @Override
    protected LookupService getLookupService() {
        return this.lookups;
    }

    @Override
    protected PracticeService getPracticeService() {
        return this.practiceService;
    }

    @Override
    protected Currencies getCurrencies() {
        return this.currencies;
    }

    @Override
    protected AddressFormatter getAddressFormatter() {
        return this.addressFormatter;
    }

    @Override
    protected PatientAgeFormatter getPatientAgeFormatter() {
        return this.ageFormatter;
    }

    @Override
    protected ImageService getImageService() {
        return this.imageService;
    }

    @Override
    protected LogoService getLogoService() {
        return this.logoService;
    }

    @Override
    protected PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

