/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.csv.CSVReaderException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;

public abstract class AbstractCSVReader {
    public static final String MIME_TYPE = "text/csv";
    private final DocumentHandlers handlers;
    private final char[] separators;
    private String[] header;

    protected AbstractCSVReader(DocumentHandlers handlers, String[] header, char separator) {
        this(handlers, header, new char[]{separator});
    }

    protected AbstractCSVReader(DocumentHandlers handlers, String[] header, char[] separators) {
        if (separators.length == 0) {
            throw new IllegalArgumentException("Argument 'separators' cannot be empty");
        }
        this.handlers = handlers;
        this.header = header;
        this.separators = separators;
    }

    protected List<String[]> readLines(Document document) {
        List result = null;
        DocumentHandler documentHandler = this.handlers.get(document);
        CSVReader reader = null;
        try {
            for (int i = 0; i < this.separators.length; ++i) {
                BOMInputStream content = new BOMInputStream(documentHandler.getContent(document));
                reader = new CSVReader((Reader)new InputStreamReader((InputStream)content), this.separators[i]);
                String[] first = reader.readNext();
                if (first.length > 1 || i + 1 == this.separators.length) {
                    this.checkHeader(first, document);
                    result = reader.readAll();
                    break;
                }
                reader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException exception) {
            throw new CSVReaderException(CSVReaderException.ErrorCode.ReadError, -1, exception);
        }
        return result;
    }

    protected void setHeader(String[] header) {
        this.header = header;
    }

    protected void checkHeader(String[] line, Document document) {
        if (line.length < this.header.length) {
            throw new CSVReaderException(CSVReaderException.ErrorCode.UnrecognisedDocument, 1, document.getName());
        }
        for (int i = 0; i < this.header.length; ++i) {
            if (StringUtils.trimToEmpty((String)line[i]).equalsIgnoreCase(this.header[i])) continue;
            throw new CSVReaderException(CSVReaderException.ErrorCode.InvalidColumn, 1, line[i]);
        }
    }

    protected int getInt(String[] line, int index, int lineNo, boolean required) {
        String value = this.getString(line, index, lineNo, required);
        int result = -1;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                this.reportInvalid(this.header[index], value, lineNo);
            }
        }
        return result;
    }

    protected long getLong(String[] line, int index, int lineNo, boolean required) {
        String value = this.getString(line, index, lineNo, required);
        long result = -1L;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException exception) {
                this.reportInvalid(this.header[index], value, lineNo);
            }
        }
        return result;
    }

    protected BigDecimal getDecimal(String[] line, int index, int lineNo, boolean required) {
        String value = this.getString(line, index, lineNo, required);
        BigDecimal result = null;
        try {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                result = new BigDecimal(value);
            }
        }
        catch (NumberFormatException exception) {
            this.reportInvalid(this.header[index], value, lineNo);
        }
        return result;
    }

    protected boolean getBoolean(String[] line, int index, int lineNo) {
        String value = this.getString(line, index, lineNo, false);
        return Boolean.parseBoolean(value);
    }

    protected String getString(String[] line, int index, int lineNo, boolean required) {
        return this.getString(line, index, lineNo, required, NewlineBehaviour.FAIL);
    }

    protected String getString(String[] line, int index, int lineNo, boolean required, NewlineBehaviour newlineBehaviour) {
        String value = StringUtils.trimToNull((String)line[index]);
        if (value == null && required) {
            throw new CSVReaderException(CSVReaderException.ErrorCode.RequiredValue, lineNo, this.header[index]);
        }
        if (value != null) {
            if (newlineBehaviour == NewlineBehaviour.REPLACE) {
                value = value.replaceAll("[\r\n]+", " ");
            } else if (newlineBehaviour == NewlineBehaviour.FAIL && value.matches("[\n\r]")) {
                throw new CSVReaderException(CSVReaderException.ErrorCode.InvalidValue, lineNo, this.header[index], value);
            }
        }
        return value;
    }

    protected void checkMaxLength(String value, int index, int lineNo, int maxLength) {
        if (value != null && value.length() > maxLength) {
            throw new CSVReaderException(CSVReaderException.ErrorCode.ValueTooLong, lineNo, this.header[index], maxLength);
        }
    }

    protected void reportInvalid(String name, String value, int lineNo) {
        throw new CSVReaderException(CSVReaderException.ErrorCode.InvalidValue, lineNo, name, value);
    }

    protected void checkFields(String[] line, int lineNo) {
        if (line.length < this.header.length) {
            throw new CSVReaderException(CSVReaderException.ErrorCode.InvalidLine, lineNo, lineNo, this.header.length, line.length);
        }
    }

    public static enum NewlineBehaviour {
        ALLOWED,
        REPLACE,
        FAIL;

    }
}

