/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.component.processor;

import java.util.Collections;
import java.util.Iterator;
import org.openvpms.archetype.component.processor.AbstractBatchProcessor;
import org.openvpms.component.exception.OpenVPMSException;

public abstract class IteratingBatchProcessor<Type>
extends AbstractBatchProcessor {
    private Iterator<Type> iterator;

    protected IteratingBatchProcessor(Iterator<Type> iterator) {
        this.setIterator(iterator);
    }

    protected IteratingBatchProcessor() {
        this.setIterator(Collections.emptyIterator());
    }

    @Override
    public void process() {
        try {
            while (this.iterator.hasNext()) {
                Type object = this.iterator.next();
                this.process(object);
                this.incProcessed(object);
            }
            this.processingCompleted();
        }
        catch (OpenVPMSException exception) {
            this.processingError(exception);
        }
    }

    protected abstract void process(Type var1);

    protected void processingCompleted() {
        this.notifyCompleted();
    }

    protected void processingError(Throwable exception) {
        this.notifyError(exception);
    }

    protected void setIterator(Iterator<Type> iterator) {
        this.setProcessed(0);
        this.iterator = iterator;
    }

    protected Iterator<Type> getIterator() {
        return this.iterator;
    }

    protected void incProcessed(Type object) {
        this.incProcessed(true);
    }
}

