/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.component.dispatcher;

import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Queue<T, O> {
    private final O owner;
    private long waitUntil = -1L;
    private T current;
    private Date lastProcessed;
    private Date lastError;
    private String lastErrorMessage;
    private boolean suspended;
    private static final Logger log = LoggerFactory.getLogger(Queue.class);

    protected Queue(O owner) {
        this.owner = owner;
    }

    public O getOwner() {
        return this.owner;
    }

    public synchronized T peekFirst() {
        if (this.current == null) {
            this.getNext();
        }
        return this.current;
    }

    public synchronized void processed() {
        if (this.current == null) {
            throw new IllegalStateException("No current object");
        }
        this.lastProcessed = new Date();
        this.processed(this.current, this.lastProcessed);
    }

    public synchronized void error(Throwable exception) {
        Date now = new Date();
        String error = exception.getMessage();
        if (error == null) {
            error = ExceptionUtils.getMessage((Throwable)exception);
        }
        log.error("Error received from {}: {}", (Object)this.toString(this.owner), (Object)error);
        this.completed(now, error);
    }

    public synchronized void setSuspended(boolean suspend) {
        this.suspended = suspend;
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public synchronized long getWaitUntil() {
        return this.waitUntil;
    }

    public synchronized void setWaitUntil(long millis) {
        this.waitUntil = millis;
    }

    public synchronized Date getProcessedTimestamp() {
        return this.lastProcessed;
    }

    public synchronized Date getErrorTimestamp() {
        return this.lastError;
    }

    public synchronized String getErrorMessage() {
        return this.lastErrorMessage;
    }

    public abstract int getRetryInterval();

    public String toString() {
        return this.toString(this.owner);
    }

    protected void processed(T object, Date processed) {
        this.completed(null, null);
    }

    protected abstract T getNext(O var1);

    protected void completed(Date errorDate, String error) {
        this.current = null;
        this.lastError = errorDate;
        this.lastErrorMessage = error;
    }

    protected String toString(O owner) {
        return owner.toString();
    }

    private void getNext() {
        this.current = this.getNext(this.owner);
    }
}

