/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.component.dispatcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.component.dispatcher.Queues;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.MonitoringIMObjectCache;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;

public abstract class MonitoredQueues<O extends IMObject, Q>
extends MonitoringIMObjectCache<O>
implements Queues<O, Q> {
    private final Map<Reference, Q> queues = Collections.synchronizedMap(new HashMap());

    protected MonitoredQueues(IArchetypeService service, String archetype, Class<O> ownerType) {
        super(service, archetype, ownerType, false);
    }

    @Override
    public List<Q> getQueues() {
        return new ArrayList<Q>(this.queues.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Q getQueue(O owner) {
        Q queue;
        Map<Reference, Q> map = this.queues;
        synchronized (map) {
            queue = this.queues.get(owner.getObjectReference());
            if (queue == null) {
                queue = this.createQueue(owner);
                this.queues.put(owner.getObjectReference(), queue);
            }
        }
        return queue;
    }

    protected abstract Q createQueue(O var1);

    protected void added(O object) {
        this.queues.put(object.getObjectReference(), this.createQueue(object));
    }

    protected void removed(O object) {
        this.queues.remove(object.getObjectReference());
    }
}

