/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import org.openvpms.etl.tools.doc.DefaultLoaderListener;
import org.openvpms.etl.tools.doc.DelegatingLoaderListener;
import org.openvpms.etl.tools.doc.LoaderListener;
import org.slf4j.Logger;

public class LoggingLoaderListener
extends DelegatingLoaderListener {
    private final Logger log;

    public LoggingLoaderListener(Logger log) {
        this(log, new DefaultLoaderListener());
    }

    public LoggingLoaderListener(Logger log, LoaderListener listener) {
        super(listener);
        this.log = log;
    }

    @Override
    public void loaded(File file, long id, File target) {
        super.loaded(file, id, target);
        this.log.info("Loaded {}, identifier={}", (Object)target.getPath(), (Object)id);
    }

    @Override
    public void alreadyLoaded(File file, long id, File target) {
        super.alreadyLoaded(file, id, target);
        this.log.info("Skipping {}, identifier={}", (Object)target.getPath(), (Object)id);
    }

    @Override
    public void missingAct(File file, long id, File target) {
        super.missingAct(file, id, target);
        this.log.info("Missing act for {}, identifier={}", (Object)target.getPath(), (Object)id);
    }

    @Override
    public void missingAct(File file, File target) {
        super.missingAct(file, target);
        this.log.info("Missing act for {}", (Object)target.getPath());
    }

    @Override
    public void error(File file, Throwable exception, File target) {
        super.error(file, exception, target);
        this.log.info("Error {}", (Object)target.getPath(), (Object)exception);
    }

    @Override
    public void error(File file, String message, File target) {
        super.error(file, message, target);
        this.log.info("Error {}: {}", (Object)target.getPath(), (Object)message);
    }
}

