/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.etl.tools.doc.DocumentFactory;
import org.openvpms.etl.tools.doc.DocumentLoaderException;
import org.openvpms.etl.tools.doc.LoadContext;
import org.openvpms.etl.tools.doc.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractLoader
implements Loader {
    private final String[] shortNames;
    private final Iterator<File> iterator;
    private final boolean overwrite;
    private final IArchetypeService service;
    private final DocumentFactory factory;
    private final PlatformTransactionManager transactionManager;
    private final DocumentRules rules;
    private static final Logger log = LoggerFactory.getLogger(AbstractLoader.class);

    protected AbstractLoader(File dir, String[] shortNames, IArchetypeService service, DocumentFactory factory, PlatformTransactionManager transactionManager, boolean recurse, boolean overwrite) {
        this.shortNames = AbstractLoader.getDocumentActShortNames(shortNames, service);
        if (this.shortNames.length == 0) {
            throw new IllegalArgumentException("Argument 'shortNames' doesn't refer to any valid archetype for loading documents to: " + ArrayUtils.toString((Object)shortNames));
        }
        if (log.isInfoEnabled()) {
            log.info("Loading documents for archetypes={}", (Object)StringUtils.join((Object[])this.shortNames, (String)", "));
        }
        this.overwrite = overwrite;
        if (log.isDebugEnabled()) {
            log.debug("dir={}", (Object)dir);
            log.debug("recurse={}", (Object)recurse);
        }
        List<File> files = this.getFiles(dir, recurse);
        this.iterator = files.iterator();
        this.service = service;
        this.factory = factory;
        this.transactionManager = transactionManager;
        this.rules = new DocumentRules((ArchetypeService)service);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public boolean loadNext() {
        return this.load(this.iterator.next(), this.overwrite);
    }

    protected String[] getShortNames() {
        return this.shortNames;
    }

    protected abstract boolean load(File var1, boolean var2);

    protected boolean load(DocumentAct act, File file, boolean overwrite, LoadContext context) {
        boolean result = false;
        if (act.getDocument() == null || overwrite) {
            result = this.loadWithDuplicateCheck(act, file, context);
        } else {
            context.alreadyLoaded(file, act.getId());
        }
        return result;
    }

    protected Document createDocument(File file) {
        return this.factory.create(file);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected boolean loadWithDuplicateCheck(DocumentAct act, File file, LoadContext context) {
        boolean result = false;
        try {
            if ("CANCELLED".equals(act.getStatus())) {
                throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.CannotLoadToCancelledAct, DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service), act.getId());
            }
            Document doc = this.createDocument(file);
            DocumentAct duplicate = this.getDuplicate(act, doc);
            if (duplicate != null && file.getName().equals(duplicate.getFileName())) {
                context.alreadyLoaded(file, act.getId());
            } else {
                if (TypeHelper.isA((IMObject)act, (String)"act.patientInvestigation")) {
                    act.setStatus2("RECEIVED");
                } else if (!"POSTED".equals(act.getStatus())) {
                    act.setStatus("COMPLETED");
                }
                boolean version = duplicate != act;
                this.addDocument(act, doc, version);
                context.loaded(file, act.getId());
                result = true;
            }
        }
        catch (Exception exception) {
            context.error(file, exception);
        }
        return result;
    }

    protected void addDocument(final DocumentAct act, final Document document, final boolean version) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AbstractLoader.this.addDocument(act, document, version, AbstractLoader.this.service);
            }
        });
    }

    protected void addDocument(DocumentAct act, Document document, boolean version, IArchetypeService service) {
        this.removeDuplicate(act, document);
        List objects = this.rules.addDocument(act, (org.openvpms.component.model.document.Document)document, version);
        service.save((Collection)objects);
    }

    protected DocumentAct getAct(long id, String shortName) {
        return this.getAct(id, new String[]{shortName});
    }

    protected DocumentAct getAct(long id, String[] shortNames) {
        ArchetypeQuery query = new ArchetypeQuery(shortNames, true, true);
        query.add((IConstraint)new NodeConstraint("id", (Object)id));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (DocumentAct)iterator.next() : null;
    }

    protected DocumentAct getDuplicate(DocumentAct act, Document document) {
        DocumentAct result = null;
        if (this.rules.isDuplicate(act, (org.openvpms.component.model.document.Document)document)) {
            result = act;
        } else {
            for (DocumentAct version : this.rules.getVersions(act)) {
                if (!this.rules.isDuplicate(version, (org.openvpms.component.model.document.Document)document)) continue;
                result = version;
                break;
            }
        }
        return result;
    }

    protected void removeDuplicate(DocumentAct act, Document document) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        for (DocumentAct version : this.rules.getVersions(act)) {
            if (!this.rules.isDuplicate(version, (org.openvpms.component.model.document.Document)document)) continue;
            ActRelationship r = (ActRelationship)bean.getValue("versions", ActRelationship.class, Predicates.targetEquals((IMObject)version));
            version.removeActRelationship(r);
            act.removeActRelationship(r);
            this.service.save((IMObject)act);
            this.service.remove((IMObject)version);
            Document dupDoc = (Document)this.service.get(version.getDocument());
            if (dupDoc == null) break;
            this.service.remove((IMObject)dupDoc);
            break;
        }
    }

    protected List<File> getFiles(File dir, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>(FileUtils.listFiles((File)dir, null, (boolean)recurse));
        files.sort(Comparator.comparingLong(File::lastModified));
        return files;
    }

    private static String[] getDocumentActShortNames(String[] shortNames, IArchetypeService service) {
        ArrayList<String> result = new ArrayList<String>();
        List descriptors = shortNames == null || shortNames.length == 0 ? service.getArchetypeDescriptors() : DescriptorHelper.getArchetypeDescriptors((String[])shortNames, (ArchetypeService)service);
        for (ArchetypeDescriptor descriptor : descriptors) {
            if (!DocumentAct.class.isAssignableFrom(descriptor.getClassType()) || !descriptor.isPrimary() || descriptor.getNodeDescriptor("document") == null || descriptor.getNodeDescriptor("fileName") == null) continue;
            result.add(descriptor.getArchetypeType());
        }
        result.remove("act.documentTemplate");
        return result.toArray(new String[0]);
    }
}

